/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.swift.request.trade.pay;

import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.trade.pay.SwiftTradeNativeResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotNull;
import com.fshows.swift.enums.api.SwiftApiDefinitionEnum;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 *
 *
 * @author
 * @version SwiftTradeNativeRequest.java, v 0.1 2023-10-18 17:31:34
 */
@Data
public class SwiftTradeNativeRequest extends SwiftBizRequest<SwiftTradeNativeResponse, SwiftApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555842917514L;


    /**
     * 门店号
     *
     * 门店号，由平台分配
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchId长度不能超过15")
    private String mchId;

    /**
     * 商户订单号
     *
     * 商户系统内部的订单号 ,32个字符内、 可包含字母,确保在商户系统唯一
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

    /**
     * 设备号
     *
     * 终端设备号
     * (选填)
     */
    @Length(max = 32, message = "deviceInfo长度不能超过32")
    private String deviceInfo;

    /**
     * 操作员
     *
     * 操作员帐号,默认为门店编号
     * (选填)
     */
    @Length(max = 32, message = "opUserId长度不能超过32")
    private String opUserId;

    /**
     * 商品描述
     *
     * 商品描述
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "body长度不能超过128")
    private String body;

    /**
     * 分账信息
     *
     * 必须按照规范上传，JSON格式，详见【分账字段说明】
     * (选填)
     */
    @Length(max = 512, message = "profitShareInfos长度不能超过512")
    private String profitShareInfos;

    /**
     * 花呗分期数
     *
     * 只支持传"3"|"6"|"12"，只适用于支付宝支付
     * (选填)
     */
    private String hbFqNum;

    /**
     * 承担手续费角色【支付宝】
     *
     * 只支持传"0"|"100"，商家承担手续费传"100"，用户承担传"0"，在有hb_fq_num字段时默认为“0 ”
     * (选填)
     */
    private String hbFqSellerPercent;

    /**
     * 附加信息
     *
     * 商户附加信息，可做扩展参数
     * (选填)
     */
    @Length(max = 127, message = "attach长度不能超过127")
    private String attach;

    /**
     * 公众账号ID
     *
     * 微信公众平台基本配置中的AppID(应用ID)，传入后支付成功可返回对应公众号下的用户openid
     * (选填)
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;

    /**
     * 总金额
     *
     * 总金额，以分为单位，不允许包含任何字、符号
     * (必填)
     */
    @NotNull
    private Integer totalFee;

    /**
     * 电子发票
     *
     * 需要和微信公众平台的发票功能联合，传入true时，微信支付成功消息和支付详情页将出现开票入口[新增need_receipt【适用于微信】]
     * (选填)
     */
    private Boolean needReceipt;

    /**
     * 终端IP
     *
     * 上传商户真实的发起交易的终端出网IP
     * (必填)
     */
    @NotBlank
    private String mchCreateIp;

    /**
     * 通知地址
     *
     * 接收平台异步回调通知的地址，必须为外网可访问的url，确保平台能通过互联网访问该地址，若无需接收通知，请固定传值为127.0.0.1
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "notifyUrl长度不能超过255")
    private String notifyUrl;

    /**
     * 前台地址
     *
     * 前端页面跳转的URL（包括支付成功和关闭时都会跳到这个地址,商户需自行处理逻辑），需给绝对路径，255字符内格式如:http://wap.tenpay.com/callback.asp注:该地址只作为前端页面的一个跳转，须使用notify_url通知结果作为支付最终结果。
     * (选填)
     */
    @Length(max = 255, message = "callbackUrl长度不能超过255")
    private String callbackUrl;

    /**
     * 订单生成时间
     *
     * 订单生成时间，格式为yyyyMMddHHmmss，如2009年12月25日9点10分10秒表示为20091225091010。时区为GMT+8 beijing。该时间取自商户服务器。注：订单生成时间与超时时间需要同时传入才会生效。
     * (选填)
     */
    @Length(max = 14, message = "timeStart长度不能超过14")
    private String timeStart;

    /**
     * 订单超时时间
     *
     * 订单失效时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。时区为GMT+8 beijing。该时间取自商户服务器。注：订单生成时间与超时时间需要同时传入才会生效。
     * (选填)
     */
    @Length(max = 14, message = "timeExpire长度不能超过14")
    private String timeExpire;

    /**
     * 商品标记
     *
     * 商品标记，微信平台配置的商品标记，用于优惠券或者满减使用
     * (选填)
     */
    @Length(max = 32, message = "goodsTag长度不能超过32")
    private String goodsTag;

    /**
     * 是否限制信用卡
     *
     * 限定用户使用时能否使用信用卡，值为1，禁用信用卡；值为0或者不传此参数则不禁用
     * (选填)
     */
    @Length(max = 32, message = "limitCreditPay长度不能超过32")
    private String limitCreditPay;

}