/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.swift.client.impl.http;

import com.fshows.swift.client.base.ApiClientConfig;
import com.fshows.swift.client.base.IHttpRequest;
import com.fshows.swift.client.base.SwiftHttpResult;
import com.fshows.swift.util.FsHttpUtil;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * http请求实现类
 *
 * @author liluqing
 * @version DefaultHttpRequest.java, v 0.1 2022-03-02 18:19
 */
public class BillDownloadHttpRequestImpl implements IHttpRequest {

    @Override
    public SwiftHttpResult post(String url, String authorization, String requestBody, ApiClientConfig apiClientConfig) throws Exception {
        Map<String, String> headers = new HashMap<>();
        headers.put("Accept-Encoding", "identity");

        String fsHttpResult = FsHttpUtil.postString(
                url,
                requestBody,
                apiClientConfig.getCharset(),
                "application/xml;charset=UTF-8",
                apiClientConfig.getConnectionTimeout(),
                apiClientConfig.getReadTimeout(),
                headers);
        if (fsHttpResult != null) {
            return convertHttpResult(fsHttpResult, apiClientConfig);
        }
        return null;
    }


    /**
     * fsHttpResult 转>> SwiftHttpResult
     *
     * @param response        响应
     * @param apiClientConfig API客户端配置
     * @return {@link SwiftHttpResult}
     * @throws ParserConfigurationException 解析器配置异常
     * @throws IOException                  ioexception
     * @throws SAXException                 saxexception
     */
    private SwiftHttpResult convertHttpResult(String response, ApiClientConfig apiClientConfig) throws ParserConfigurationException, IOException, SAXException {
        SwiftHttpResult swiftHttpResult = new SwiftHttpResult();
        swiftHttpResult.setBody(response);
        return swiftHttpResult;
    }
}