/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * @author wangqilei
 * @version PostarRefundCreateRes.java, v 0.1 2024-06-06 4:53 PM wangqilei
 */
@Data
public class PostarRefundQueryRes extends PostarBizRes {
    private static final long serialVersionUID = -1882734511948905379L;
    /**
     * 机构编号
     * 商户所在国通系统内机构号（或虚拟机构号）
     * (必填)
     */
    private String agetId;

    /**
     * 商户号
     * 商户所在国通系统内商户号
     * (必填)
     */
    private String custId;

    /**
     * 国通平台退款订单号
     * (必填)
     */
    private String orderFlowNo;

    /**
     * 服务商退款订单号
     * 退款请求时，合作商提供的第三方退款订单号
     * (特殊必填)
     */
    private String orderNo;

    /**
     * 付呗退款单号，文档中没写
     */
    private String threeOrderNo;

    /**
     * 退款金额
     * (必填)
     */
    private String refundAmt;

    /**
     * 订单状态
     * 3退款失败 4退款成功 5退款中
     * (必填)
     */
    private String orderStatus;

    /**
     * 订单时间
     * (必填)
     */
    private String orderTime;

    /**
     * 退款备注
     * (特殊必填)
     */
    private String remark;

    /**
     * 是否使用退款备付金
     * 是/否
     * (特殊必填)
     */
    private String reserveFlag;

    /**
     * 退款手续费
     * 单位：分。
     * (特殊必填)
     */
    private String refundFee;

    /**
     * 支付渠道
     * (特殊必填)
     */
    private String payChannel;

    /**
     * 交易方式
     * (特殊必填)
     */
    @JSONField(name = "txn_cnl")
    private String txnCnl;
}