/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarMerchantQueryReq.java, v 0.1 2024-10-09 10:12 weikunpeng
 */
@Data
public class PostarMerchantQueryReq extends PostarBaseReq {
    /**
     * 登入号 (必填)
     * 申请/修改接口内的登录账号
     */
    @NotBlank
    private String custLogin;

    /**
     * 商户编号 (必填)
     * 600商户号
     */
    @NotBlank
    private String custId;

}