package com.fshows.postar.apienum;

import com.fshows.postar.contant.PostarConstant;
import com.fshows.postar.enums.ApiRequestTypeEnum;
import com.fshows.postar.request.merchant.PostarAnxinSignCompanyReq;
import com.fshows.postar.request.merchant.PostarAnxinSignPersonReq;
import com.fshows.postar.request.merchant.PostarAnxinSignSendCodeReq;
import com.fshows.postar.request.merchant.PostarAnxinSignSupplementaryReq;
import com.fshows.postar.request.merchant.PostarAppidConfigReq;
import com.fshows.postar.request.merchant.PostarApplyMerchantSettlementReq;
import com.fshows.postar.request.merchant.PostarAuditQueryReq;
import com.fshows.postar.request.merchant.PostarCommonChangeReq;
import com.fshows.postar.request.merchant.PostarCommonOpenApplicationReq;
import com.fshows.postar.request.merchant.PostarCustConfigReq;
import com.fshows.postar.request.merchant.PostarMerchantQueryReq;
import com.fshows.postar.request.merchant.PostarMiniChangeReq;
import com.fshows.postar.request.merchant.PostarMiniOpenApplicationReq;
import com.fshows.postar.request.merchant.PostarProvinceQueryReq;
import com.fshows.postar.request.merchant.PostarQueryBankInfoByCardReq;
import com.fshows.postar.request.merchant.PostarQueryMerchantSettlementReq;
import com.fshows.postar.request.merchant.PostarReportQueryReq;
import com.fshows.postar.request.merchant.PostarUpdateCustAccountReq;
import com.fshows.postar.request.merchant.PostarUpdateCustRateReq;
import com.fshows.postar.request.merchant.PostarUpdateMerchantSettlementReq;
import com.fshows.postar.request.merchant.PostarUploadImageReq;
import com.fshows.postar.request.merchant.PostarWxPayConfigReq;
import com.fshows.postar.response.merchant.PostarAnxinSignCompanyRes;
import com.fshows.postar.response.merchant.PostarAnxinSignPersonRes;
import com.fshows.postar.response.merchant.PostarAnxinSignSendCodeRes;
import com.fshows.postar.response.merchant.PostarAnxinSignSupplementaryRes;
import com.fshows.postar.response.merchant.PostarAppidConfigRes;
import com.fshows.postar.response.merchant.PostarApplyMerchantSettlementRes;
import com.fshows.postar.response.merchant.PostarAuditQueryRes;
import com.fshows.postar.response.merchant.PostarCommonChangeRes;
import com.fshows.postar.response.merchant.PostarCommonOpenApplicationRes;
import com.fshows.postar.response.merchant.PostarCustConfigRes;
import com.fshows.postar.response.merchant.PostarMerchantQueryRes;
import com.fshows.postar.response.merchant.PostarMiniChangeRes;
import com.fshows.postar.response.merchant.PostarMiniOpenApplicationRes;
import com.fshows.postar.response.merchant.PostarProvinceQueryRes;
import com.fshows.postar.response.merchant.PostarQueryBankInfoByCardRes;
import com.fshows.postar.response.merchant.PostarQueryMerchantSettlementRes;
import com.fshows.postar.response.merchant.PostarReportQueryRes;
import com.fshows.postar.response.merchant.PostarUpdateCustAccountRes;
import com.fshows.postar.response.merchant.PostarUpdateCustRateRes;
import com.fshows.postar.response.merchant.PostarUpdateMerchantSettlementRes;
import com.fshows.postar.response.merchant.PostarUploadImageRes;
import com.fshows.postar.response.merchant.PostarWxPayConfigRes;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;

/**
 * 国通星驿商户相关API
 *
 * @author zhaoxumin
 * @version PostarMerchantApiEnum.java, v 0.1 2024-06-13 15:25:59 zhaoxumin
 */
public enum PostarMerchantApiEnum implements IApiDefinition {
    CUST_CONFIG(
            "指定渠道报备",
            "/yyfsevr/custConfig/config",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCustConfigReq.class,
            PostarCustConfigRes.class,
            ApiRequestTypeEnum.POST
    ),
    WX_PAY_CONFIG(
            "配置微信支付目录",
            "/yyfsevr/addCust/wxPayConfig",
            PostarConstant.DEFAULT_API_VERSION,
            PostarWxPayConfigReq.class,
            PostarWxPayConfigRes.class,
            ApiRequestTypeEnum.POST
    ),
    APPID_CONFIG(
            "微信APPID配置",
            "/yyfsevr/addCust/appidConfig",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAppidConfigReq.class,
            PostarAppidConfigRes.class,
            ApiRequestTypeEnum.POST
    ),
    UPLOAD_IMAGE(
            "商户进件上传图片",
            "/yyfsevr/addCust/uploadImg",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUploadImageReq.class,
            PostarUploadImageRes.class,
            ApiRequestTypeEnum.POST
    ),
    AUDIT_QUERY(
            "审核结果查询",
            "/yyfsevr/addCust/getResult",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAuditQueryReq.class,
            PostarAuditQueryRes.class,
            ApiRequestTypeEnum.GET
    ),
    MINI_OPEN_APPLICATION(
            "小微商户申请/驳回重新申请",
            "/yyfsevr/addCust/miniApply",
            PostarConstant.DEFAULT_API_VERSION,
            PostarMiniOpenApplicationReq.class,
            PostarMiniOpenApplicationRes.class,
            ApiRequestTypeEnum.POST
    ),
    MINI_CHANGE(
            "小微商户修改",
            "/yyfsevr/addCust/updateMini",
            PostarConstant.DEFAULT_API_VERSION,
            PostarMiniChangeReq.class,
            PostarMiniChangeRes.class,
            ApiRequestTypeEnum.POST
    ),
    COMMON_OPEN_APPLICATION(
            "普通商户申请/驳回重新申请",
            "/yyfsevr/addCust/commonApply",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCommonOpenApplicationReq.class,
            PostarCommonOpenApplicationRes.class,
            ApiRequestTypeEnum.POST
    ),
    COMMON_CHANGE(
            "普通商户修改",
            "/yyfsevr/addCust/updateCommon",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCommonChangeReq.class,
            PostarCommonChangeRes.class,
            ApiRequestTypeEnum.POST
    ),
    MERCHANT_QUERY(
            "获取商户信息",
            "/yyfsevr/addCust/getCustInfo",
            PostarConstant.DEFAULT_API_VERSION,
            PostarMerchantQueryReq.class,
            PostarMerchantQueryRes.class,
            ApiRequestTypeEnum.GET
    ),
    PROVINCE_QUERY(
            "获取省",
            "/yyfsevr/addCust/getProvince",
            PostarConstant.DEFAULT_API_VERSION,
            PostarProvinceQueryReq.class,
            PostarProvinceQueryRes.class,
            ApiRequestTypeEnum.GET
    ),
    REPORT_QUERY(
            "查询报备信息",
            "/yyfsevr/addCust/getReportInfo",
            PostarConstant.DEFAULT_API_VERSION,
            PostarReportQueryReq.class,
            PostarReportQueryRes.class,
            ApiRequestTypeEnum.POST
    ),
    ANXIN_SIGN_PERSON(
            "安心签个人用户开户",
            "/yyfsevr/anxinsign/person",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAnxinSignPersonReq.class,
            PostarAnxinSignPersonRes.class,
            ApiRequestTypeEnum.POST
    ),
    ANXIN_SIGN_SEND_CODE(
            "安心签发短信验证码",
            "/yyfsevr/anxinsign/sendCode",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAnxinSignSendCodeReq.class,
            PostarAnxinSignSendCodeRes.class,
            ApiRequestTypeEnum.POST
    ),
    ANXIN_SIGN_SUPPLEMENTARY(
            "安心签补签",
            "/yyfsevr/anxinsign/supplementary",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAnxinSignSupplementaryReq.class,
            PostarAnxinSignSupplementaryRes.class,
            ApiRequestTypeEnum.POST
    ),
    ANXIN_SIGN_COMPANY(
            "安心签企业用户开户",
            "/yyfsevr/anxinsign/company",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAnxinSignCompanyReq.class,
            PostarAnxinSignCompanyRes.class,
            ApiRequestTypeEnum.POST
    ),
    UPDATE_CUST_ACCOUNT(
            "修改结算卡",
            "/yyfsevr/addCust/updateCustAccount",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUpdateCustAccountReq.class,
            PostarUpdateCustAccountRes.class,
            ApiRequestTypeEnum.POST
    ),
    UPDATE_CUST_RATE(
            "修改商户费率",
            "/yyfsevr/addCust/updateCustRate",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUpdateCustRateReq.class,
            PostarUpdateCustRateRes.class,
            ApiRequestTypeEnum.POST
    ),
    QUERY_BANK_INFO_BY_CARD(
            "根据银行卡号获取银行信息",
            "/yyfsevr/addCust/queryInfoByCard",
            PostarConstant.DEFAULT_API_VERSION,
            PostarQueryBankInfoByCardReq.class,
            PostarQueryBankInfoByCardRes.class,
            ApiRequestTypeEnum.GET
    ),
    APPLY_MERCHANT_SETTLEMENT(
            "结算业务申请",
            "/yyfsevr/addCust/applyStlmt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarApplyMerchantSettlementReq.class,
            PostarApplyMerchantSettlementRes.class,
            ApiRequestTypeEnum.POST
    ),
    UPDATE_MERCHANT_SETTLEMENT(
            "结算业务变更",
            "/yyfsevr/addCust/updateStlmt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUpdateMerchantSettlementReq.class,
            PostarUpdateMerchantSettlementRes.class,
            ApiRequestTypeEnum.POST
    ),
    QUERY_MERCHANT_SETTLEMENT(
            "结算业务状态查询",
            "/yyfsevr/addCust/queryStlmt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarQueryMerchantSettlementReq.class,
            PostarQueryMerchantSettlementRes.class,
            ApiRequestTypeEnum.POST
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本，默认1.0
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;
    /**
     * 请求类型
     */
    private ApiRequestTypeEnum apiRequestType;


    PostarMerchantApiEnum(String name,
                          String apiSubURI,
                          String version,
                          Class requestClass,
                          Class responseClass,
                          ApiRequestTypeEnum ApiRequestTypeEnum) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
        this.apiRequestType = ApiRequestTypeEnum;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    public ApiRequestTypeEnum getApiRequestType() {
        return apiRequestType;
    }
}