/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.postar.response.PostarBizRes;
import com.fshows.postar.response.trade.detail.AcqAddnData;
import com.fshows.postar.response.trade.detail.GoodsDetail;
import com.fshows.postar.response.trade.detail.PromotionDetail;
import lombok.Data;

import java.util.List;

/**
 * @author wangqilei
 * @version PostarOrderQueryRes.java, v 0.1 2024-06-05 5:51 PM wangqilei
 */
@Data
public class PostarOrderQueryRes extends PostarBizRes {
    private static final long serialVersionUID = -8424758196753423534L;
    /**
     * 商户实收金额
     * 单位分，原订单交易金额-官方商户出资金额-商户交易实收手续费
     * (必填)
     */
    private String netrAmt;

    /**
     * 原订单交易金额
     * 单位分，对应下单接口txamt
     * (必填)
     */
    private String txamt;

    /**
     * 商户交易实收手续费
     * 单位分，成功时返回
     * (必填)
     */
    private String custFee;
    /**
     * 官方商户出资金额
     * 单位分，成功时返回，数币交易返回官方优惠金额，该字段809商户交易不返回
     * (必填)
     */
    private String custAmt;

    /**
     * 补贴类型
     * 0无、1机构补贴、2公司补贴、11落地机构补贴
     * (必填)
     */
    private String discountFlag;

    /**
     * 优惠手续费
     * 优惠手续费=应收手续费-实收手续费
     * (必填)
     */
    private String discountFee;

    /**
     * 国通平台订单号
     * 国通平台订单号，可用于退款
     * (必填)
     */
    private String orderNo;

    /**
     * 第三方订单号
     * 合作方订单号
     * (必填)
     */
    private String threeOrderNo;

    /**
     * 官方支付平台单号,目的通道流水
     * 微信/支付宝（目的通道流水号），银联（官方订单号）可用于退款
     * (必填)
     */
    private String torderNo;

    /**
     * 支付通道官方订单号
     * 微信、支付宝官方通道订单号
     * (必填)
     */
    private String payNo;

    /**
     * 订单完成时间（成功时返回）
     * (必填)
     */
    private String orderTime;

    /**
     * 支付方式
     * 0银联主扫 1支付宝主扫 2微信主扫 3付款码支付(银联被扫) 5公众号支付(微信被扫)
     * 7服务窗支付(支付宝被扫）8小程序普通交易（成功时返回）60数币B扫C 61数币被扫（C扫B）
     * (必填)
     */
    private String payWay;

    /**
     * 卡类型
     * 01借记卡、 02贷记卡、03其他
     * (必填)
     */
    private String cardType;

    /**
     * 机构编号
     * (必填)
     */
    private String agetId;

    /**
     * 消费者OPEN_ID
     * 成功时返回
     * (必填)
     */
    private String openId;

    /**
     * 消费者IP
     * 成功时返回
     * (必填)
     */
    private String tradingIp;

    /**
     * 交易手续费补贴金额
     * 单位 分
     */
    private String limitFee;

    /**
     * 花呗分期
     * 花呗分期数，当前仅支持3、6、12
     */
    private String hbFqNum;

    /**
     * 信用卡分期
     * 信用卡分期数，当前仅支持3、6、12
     */
    private String crFqNum;

    /**
     * 银行英文缩写
     * (选填)
     */
    private String bankCode;

    /**
     * 银行名称
     * (选填)
     */
    private String bankName;

    /**
     * 支付宝,微信单品优惠
     */
    @JSONField(name = "promotion_detail")
    private List<PromotionDetail> promotionDetailList;

    /**
     * 银联单品优惠
     */
    private AcqAddnData acqAddnData;
}