/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.merchant;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * @author weikunpeng
 * @version PostarAuditQueryRes.java, v 0.1 2024-10-08 19:20 weikunpeng
 */
@Data
public class PostarAuditQueryRes extends PostarBizRes {

    /**
     * 审核模式。
     * 1 自动审核，0 人工审核。
     */
    private String auditType;

    /**
     * 审核状态（枚举）。
     * 0 暂存，1 审核中，2 审核通过，3 审核不通过。
     */
    private String usrStatus;

    /**
     * 审核状态（文字）。
     * 0 暂存，1 审核中，2 审核通过，3 审核不通过。
     */
    private String usrStatusText;

    /**
     * 审核结果。
     * 00 审核通过；后续字段皆为审核失败的具体描述。
     */
    private String authResult;

    /**
     * 未通过原因。
     * 文字描述，说明未通过的原因。
     */
    private String notThrowReason;

    /**
     * 安心签重签标识。
     * 0 否，1 是。
     */
    private String anxinsign;

    /**
     * 审核类型。
     * 0 正常入网，2 信息修改，4 结算卡修改。空值默认查询正常入网。
     */
    private String authType;

}