/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.share.split.detail;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 子户转账交易明细
 *
 * @author wangyi
 * @version SubAccountTransLog.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class SubAccountTransLog {

    /**
     * 分账流水号
     */
    private String tradeId;

    /**
     * 分账出款方商户号，600商户在星驿付的唯一代码
     */
    private String outCustId;

    /**
     * 接收方商户号，600商户在星驿付的唯一代码
     */
    private String inCustId;

    /**
     * 接收方客户号
     */
    private String inCustomerId;

    /**
     * 出款方客户号
     */
    private String outCustomerId;

    /**
     * 金额：元
     */
    private BigDecimal txAmt;

    /**
     * 交易状态
     * 0-待执行 1-交易成功 2-交易失败 3-处理中 4-交易异常
     */
    private Integer tradeStatus;
}
