/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.share.split.detail;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 分账订单查询交易明细
 *
 * @author wangyi
 * @version SplitQueryTradeLog.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class SplitQueryTradeLog {

    /**
     * 分账流水号
     */
    private String tradeId;

    /**
     * 分账出款方商户号，600商户在星驿付的唯一代码
     */
    private String outCustId;

    /**
     * 接收方商户号，600商户在星驿付的唯一代码
     */
    private String inCustId;

    /**
     * 接收方客户号
     */
    private String inCustomerId;

    /**
     * 分账金额：元
     */
    private BigDecimal txAmt;

    /**
     * 手续费：元
     */
    private BigDecimal fee;

    /**
     * 出款方承担手续费：元
     */
    private BigDecimal feeOut;

    /**
     * 接收方承担手续费：元
     */
    private BigDecimal feeIn;

    /**
     * 交易状态
     * 0-待执行 1-交易成功 2-交易失败 3-处理中 4-交易异常
     */
    private Integer tradeStatus;

    /**
     * 结算状态
     * 0-不结算 1-待结算 2-结算中 3-结算成功 4-结算失败
     */
    private Integer cashStatus;

    /**
     * 提现订单号
     * 结算状态 2-结算中 3-结算成功 时返回
     */
    private String withId;

    /**
     * 分账交易完成时间
     * 格式：yyyyMMddHHmmss
     */
    private String splitTime;

    /**
     * 结算完成时间
     * 需结算的订单，结算成功后返回yyyyMMddHHmmss
     */
    private String withTime;

    /**
     * 订单退回状态
     * 0-未退回 1-已回退 2-退回中 3-退回失败
     */
    private String returnStatus;

    /**
     * 订单撤销状态
     * 0-未撤销 1-已撤销 2-撤销中 3-撤销失败
     */
    private String revokeStatus;
}
