/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.share.dict;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * 根据银行卡号获取银行信息响应
 *
 * @author wangyi
 * @version PostarQueryInfoByCardRes.java, v 0.1 2025-12-10 09:30 wangyi
 */
@Data
public class PostarQueryInfoByCardRes extends PostarBizRes {

    /**
     * 银行缩写
     */
    private String bankCode;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 卡类型
     * 0-借记卡 1-贷记卡
     */
    private String crdFlag;
}
