/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.share.collect.detail;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 归集订单查询交易明细
 *
 * @author wangyi
 * @version CollectQueryTradeLog.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class CollectQueryTradeLog {

    /**
     * 归集流水号
     */
    private String tradeId;

    /**
     * 归集出款方商户号，600商户在星驿付的唯一代码
     */
    private String outCustId;

    /**
     * 接收方商户号，600商户在星驿付的唯一代码
     */
    private String inCustId;

    /**
     * 接收方客户号
     */
    private String inCustomerId;

    /**
     * 归集金额：元
     */
    private BigDecimal txAmt;

    /**
     * 手续费：元
     */
    private BigDecimal fee;

    /**
     * 出款方承担手续费：元
     */
    private BigDecimal feeOut;

    /**
     * 接收方承担手续费：元
     */
    private BigDecimal feeIn;

    /**
     * 附言
     */
    private String tradeMemo;

    /**
     * 交易状态
     * 0-待执行 1-交易成功 2-交易失败 3-处理中 4-交易异常
     */
    private Integer tradeStatus;

    /**
     * 结算状态
     * 0-不结算 1-待结算 2-结算中 3-结算成功 4-结算失败
     */
    private Integer cashStatus;
}
