/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.customer.detail;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 客户基础信息
 *
 * @author wangyi
 * @version CustomerBaseInfo.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class CustomerBaseInfo {

    /**
     * 商户id
     * 选择600商户在星驿付的唯一代码,作为接收方新增客户，不传就新增客户作为接收方
     * 必填: 否
     */
    private String custId;

    /**
     * 客户类型
     * 0企业 1个人
     * 必填: 是
     */
    private String customerType;

    /**
     * 结算类型
     * 0-对公，1-对私
     * 客户类型为企业，可以选择 0-对公，1-对私
     * 客户类型为个人，选1-对私
     * 必填: 是
     */
    private String settleType;

    /**
     * 身份证姓名（法人姓名）
     * 必填: 是
     */
    private String idCardName;

    /**
     * 身份证号
     * 必填: 是
     */
    private String idCard;

    /**
     * 统一社会信用代码
     * 企业必须送
     * 必填: 否
     */
    private String usci;

    /**
     * 联系手机号
     * 必填: 是
     */
    private String phoneNo;

    /**
     * 客户最大分账比例
     * 单位%，例如送1就是1%
     * 必填: 是
     */
    private BigDecimal maxValue;

    /**
     * 标签
     * 必填: 否
     */
    private String tag;

    /**
     * 到账方式
     * 0 直接到卡 1 手工提现
     * 必填: 是
     */
    private String receiptType;

    /**
     * 结算周期
     * 0:D0 1:T1 2:D1
     * receiptType为1手工提现则settlementCycle使用0:D0
     * 必填: 是
     */
    private String settlementCycle;

    /**
     * 是否合并入账
     * 0-否 1-是，默认否，选择是的话，当天分账需结算订单，待第二天凌晨发起一笔结算提现
     * 必填: 否
     */
    private String isMergeWithDraw;

    /**
     * 签约对象
     * 0接收方签约，1商户方签约
     * 必填: 是
     */
    private String signTarget;
}
