/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.customer.detail;

import lombok.Data;

/**
 * 分账授权基础信息
 *
 * @author wangyi
 * @version AuthorizationBaseInfo.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class AuthorizationBaseInfo {

    /**
     * 商户id
     * 选择600商户在星驿付的唯一代码,作为接收方新增客户，不传就新增客户作为接收方
     * 必填: 是
     */
    private String custId;

    /**
     * 最大分账比例
     * 单位%，例如送1就是1%
     * 必填: 是
     */
    private String maxValue;

    /**
     * 标签
     * 必填: 否
     */
    private String tag;

    /**
     * 是否合并入账
     * 0-否 1-是，默认否，选择是的话，当天分账需结算订单，待第二天凌晨发起一笔结算提现
     * 必填: 否
     */
    private String isMergeWithDraw;

    /**
     * 签约对象
     * 0接收方签约，1商户方签约
     * 必填: 是
     */
    private String signTarget;
}
