/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.customer;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.share.customer.detail.AttachmentInfo;
import com.fshows.postar.request.share.customer.detail.AuthorizationBaseInfo;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 分账授权申请接口-收单统一结算(XZY043)请求
 *
 * @author wangyi
 * @version PostarAuthorizationSplitReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarAuthorizationSplitReq extends PostarBaseReq {

    /**
     * 分账功能管理员商户
     * 600商户在星驿付的唯一代码，作为分账出款方
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 请求时间戳
     * 格式：yyyyMMddHHmmss
     * 必填: 是
     */
    @NotBlank
    private String timestamp;

    /**
     * 基础信息
     * 必填: 是
     */
    @NotNull
    private AuthorizationBaseInfo customerBaseInfo;

    /**
     * 附件信息
     * 必填: 否
     */
    private List<AttachmentInfo> attachmentList;
}
