/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.share.detail.AcntSplitDetail;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 分账请求
 *
 * @author wangyi
 * @version PostarShareSplitReq.java, v 0.1 2025-12-10 09:19 wangyi
 */
@Data
public class PostarShareSplitReq extends PostarBaseReq {

    /**
     * 分账功能管理员商户的600商户号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 分账明细列表
     * 必填: 是
     */
    @NotEmpty
    private List<AcntSplitDetail> acntSplitDetails;

    /**
     * 分账备注
     * 必填: 否
     */
    private String remark;

    /**
     * 分账金额来源
     * 0-订单 1-余额
     * 必填: 是
     */
    @NotBlank
    private String txAmtSource;

    /**
     * 三方订单号
     * 必填: 是
     */
    @NotBlank
    private String otherOrderNo;

    /**
     * 分账交易订单号列表
     * 分账金额来源:0-订单 时必传
     * 必填: 否
     */
    private List<String> orders;
}
