/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarOpenApplicationReq.java, v 0.1 2024-10-09 08:59 weikunpeng
 */
@Data
public class PostarMiniOpenApplicationReq extends PostarBaseReq {
    /**
     * 进件机构号。
     * 若“机构号”字段为虚拟机构号，则“进件机构号”字段必传。
     * 必填: 否
     */
    private String applyAgentId;

    /**
     * 操作类型。
     * 1: 新增, 2: 修改（首次进件未审核通过被驳回时选择）。
     * 必填: 是
     */
    @NotBlank
    private String operType;

    /**
     * 是否首次进件（用于校验安心签，已经安心签必传）。
     * 0: 是, 1: 驳回重新进件（用于校验安心签，安心签必传，安心签后签不传验证码时候不能传）。
     * 必填: 否
     */
    private String isFirstCust;

    /**
     * 商户号（修改的时候必须上传）。
     * 必填: 否
     */
    private String custId;

    /**
     * 登入账号（手机号）。
     * 该手机号可登录国通商户APP。
     * 必填: 是
     */
    @NotBlank
    private String custLogin;

    /**
     * 商户名称（门店名称）。
     * 建议输入市+名称+主营，长度控制在50个字以内（100个字符以内），
     * 建议长度5-20个字（10-40个字符），系统将根据银联规范对名称进行长度补充与截取，
     * 不足5个字的将补充“省市”信息，超出20个字的将截取后20位。
     * 必填: 是
     */
    @NotBlank
    private String busName;

    /**
     * 经营类型。
     * 01: 门店场所, 02: 流动经营/便民服务, 03: 线上商品/服务交易。
     * 必填: 是
     */
    @NotBlank
    private String manageType;

    /**
     * 所属行业。
     * 基础信息获取板块内，使用获取一级MCC目录后获取获取二级MCC目录，
     * 该字段根据二级MCC目录对应行业编号。
     * 必填: 是
     */
    @NotBlank
    private String mcccode;

    /**
     * 省。
     * 基础信息获取板块-“获取省”接口。
     * 必填: 是
     */
    @NotBlank
    private String provId;

    /**
     * 市。
     * 基础信息获取板块-“获取市”接口。
     * 必填: 是
     */
    @NotBlank
    private String cityId;

    /**
     * 区/县。
     * 基础信息获取板块-“获取区县”接口。
     * 必填: 是
     */
    @NotBlank
    private String areaId;

    /**
     * 商户经营地址。
     * 长度控制在100个字（200个字符），建议长度5-30个字（10-60个字符），
     * 系统将根据银联规范对地址进行长度补充与截取，
     * 少于5个字添加省市区进行补足，超过30个字的向后取值30个字。
     * 必填: 是
     */
    @NotBlank
    private String custAddr;

    /**
     * 经营者姓名。
     * 必填: 是
     */
    @NotBlank
    private String custName;

    /**
     * 经营者身份证号码。
     * 必填: 是
     */
    @NotBlank
    private String credNo;

    /**
     * 身份证有效期开始日期。
     * 格式: YYYYMMDD
     * 必填: 是
     */
    @NotBlank
    private String credStartDate;

    /**
     * 身份证有效期结束日期。
     * 格式: YYYYMMDD，若为永久，传“长期”。
     * 必填: 是
     */
    @NotBlank
    private String credEndDate;

    /**
     * 手机号。
     * 经营者联系方式，可与“登入账号”一致。
     * 如果有安心签，需与安心签的开户手机号一致。
     * 必填: 是
     */
    @NotBlank
    private String mobileNo;

    /**
     * 结算卡持卡人姓名。
     * 必填: 是
     */
    @NotBlank
    private String accountName;

    /**
     * 结算卡号。
     * 必填: 是
     */
    @NotBlank
    private String accountNo;

    /**
     * 开户行(缩写)。
     * 调用基础信息板块-银行信息查询/根据银行卡号获取银行信息获取。
     * 必填: 是
     */
    @NotBlank
    private String bankCode;

    /**
     * 结算类型。
     * 1: T1, 2: D1。
     * 若需开通 D0，可前往国通商户APP开通或联系联调人员获取 D0-SDK 主键嵌入自有程序。
     * 示例: 2
     * 必填: 是
     */
    @NotBlank
    private String stlType;

    /**
     * 提现手续费 D1 附加手续费。
     * 单位: % ，支持小数点后两位（结算类型为 D1 时必传）。
     * 可选: 否
     */
    private String rateTx;

    /**
     * 微信借记卡费率。
     * 单位：%，支持小数点后三位。
     * 必填: 是
     */
    @NotBlank
    private String rateWx;

    /**
     * 微信贷记卡费率。
     * 单位：%，支持小数点后三位。
     * 可选: 否
     */
    private String rateWxDj;

    /**
     * 支付宝费率。
     * 单位：%，支持小数点后三位。
     * 必填: 是
     */
    @NotBlank
    private String rateZfb;

    /**
     * 银联扫码借记卡扣率小于1000费率。
     * 单位：%，支持小数点后三位。
     * 必填: 是
     */
    @NotBlank
    private String rateYlCap0;

    /**
     * 银联扫码借记卡扣率大于1000费率。
     * 单位：%，支持小数点后三位。
     * 必填: 是
     */
    @NotBlank
    private String rateYlCap1;

    /**
     * 银联扫码贷记卡扣率小于1000费率。
     * 单位：%，支持小数点后三位。
     * 必填: 是
     */
    @NotBlank
    private String rateYlRat0;

    /**
     * 银联扫码贷记卡扣率大于1000费率。
     * 单位：%，支持小数点后三位。
     * 必填: 是
     */
    @NotBlank
    private String rateYlRat1;

    /**
     * 借记卡优惠类结算费率（%）。
     * 单位：%，支持小数点后三位。
     * 必填: 是
     */
    private String ratePosJy;

    /**
     * 借记卡标准类结算费率（%）。
     * 单位：%，支持小数点后三位。
     * 必填: 是
     */
    @NotBlank
    private String ratePosJb;

    /**
     * 贷记卡优惠类结算费率（%）。
     * 单位：%，支持小数点后三位。
     * 必填: 是
     */
    private String ratePosDy;

    /**
     * 贷记卡标准类结算费率（%）。
     * 单位：%，支持小数点后三位。
     * 必填: 是
     */
    @NotBlank
    private String ratePosDb;

    /**
     * 借记卡优惠类消费封顶值。
     * 单位：分。
     * 必填: 是
     */
    private String moneyPosJy;

    /**
     * 借记卡标准类消费封顶值。
     * 单位：分。
     * 必填: 是
     */
    @NotBlank
    private String moneyPosJb;

    /**
     * 免签免密结算费率（%）。
     * 单位：%，支持小数点后三位。
     * 早期给免签免密优惠类用的，目前无业务在用。现有的是免密免签未优惠，走的普通刷卡借贷记费率。
     * 必填: 是
     */
    private String ratePosM;

    /**
     * 刷卡闪付结算费率（%）。
     * 单位：%，支持小数点后三位。
     * 指用手机PAY闪付的费率，闪付的金额小等于1000是按闪付费率，金额大于1000是按普通刷卡借贷记费率。
     * 必填: 是
     */
    private String ratePosS;

    /**
     * 银联扫码借记卡(≤1000)封顶值。
     * 单位：分，根据机构政策区间上送，未上送时会取政策的默认封顶值。
     * 若政策未配置封顶值，则无需上送（代表不封顶）。
     * 可选: 否
     */
    private String ylJFdDef;

    /**
     * 银联扫码借记卡(>1000)封顶值。
     * 单位：分，根据机构政策区间上送，未上送时会取政策的默认封顶值。
     * 若政策未配置封顶值，则无需上送（代表不封顶）。
     * 可选: 否
     */
    private String ylJFd2Def;

    /**
     * 关联落地银行机构号。
     * 当610机构类型为“行业代理/联合收单”时，可调用进件-基础信息获取-关联落地银行品牌查询、落地银行下级机构查询接口，获取落地银行。
     * 会校验结算卡是否属于落地银行。
     * 可选: 否
     */
    private String fallAgetId;

    /**
     * 报备产品类型。
     * 0全产品，1扫码，2刷卡。
     * 必填: 是
     */
    @NotBlank
    private String custChanType;

    /**
     * 是否支持退款。
     * '0'关；'1'开。
     * 必填: 是
     */
    @NotBlank
    private String refPower;

    /**
     * 经度。
     * 商户经营地址所在经度，小数点后仅支持上传后5位，进行截取。
     * 必填: 否
     */
    private String longitude;

    /**
     * 纬度。
     * 商户经营地址所在纬度，小数点后仅支持上传后5位，进行截取。
     * 必填: 否
     */
    private String latitude;

    /**
     * 验证码（需要签署安心签才需传）。
     * 安心签开通板块-“安心签发短信验证码”，验证码有效期10-30分钟（根据接收短信上提示时间为准）。
     * 可选: 否
     */
    private String checkCode;

    /**
     * 图片接口时间戳。
     * 首次进件必传，若商户首次进件被驳回后无需修改图片则无需传输，
     * 基础进件板块-“商户进件上传图片”-时间戳timestamp字段，一个商户一个时间戳，
     * 使用首张图片国通服务器返回时间戳。
     * 可选: 否
     */
    private String timestamp;
}