/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * @author wangqilei
 * @version PostarRefundCreateRes.java, v 0.1 2024-06-06 4:53 PM wangqilei
 */
@Data
public class PostarRefundCreateRes extends PostarBizRes {
    private static final long serialVersionUID = 326045289208730409L;
    /**
     * 机构编号
     * 商户所在国通系统内机构号（或虚拟机构号）
     * (必填)
     */
    private String agetId;

    /**
     * 商户号
     * 商户所在国通系统内商户号
     * (必填)
     */
    private String custId;

    /**
     * 国通平台退款订单号
     * (必填)
     */
    private String orderFlowNo;

    /**
     * 服务商退款订单号
     * 退款请求时，合作商提供的第三方退款订单号
     * (特殊必填)
     */
    private String threeOrderNo;

    /**
     * 退款金额
     * (必填)
     */
    private String refundAmt;

    /**
     * 订单状态
     * 3退款失败 4退款成功 5退款中
     * (必填)
     */
    private String orderStatus;

    /**
     * 订单时间
     * (必填)
     */
    private String orderTime;

    /**
     * 退款手续费
     * 单位：分。
     * (特殊必填)
     */
    private String refundFee;

    /**
     * 星POS-原实付金额
     * (特殊必填)
     */
    private String amount;

    /**
     * 星POS-原订单总金额
     * (特殊必填)
     */
    private String totalAmount;

    /**
     * 星POS-订单优惠说明
     * (特殊必填)
     */
    private String goodsTag;

    /**
     * 星POS-订单标题
     * (特殊必填)
     */
    private String subject;

    /**
     * 星POS-退款明细
     * (特殊必填)
     */
    private String refundInfo;

    /**
     * 星POS-附加数据
     * (特殊必填)
     */
    private String attach;
}