/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade.detail;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author wangqilei
 * @version OrderGoodDetail.java, v 0.1 2024-06-05 3:40 PM wangqilei
 */
@Data
public class OrderGoodsDetailList {
    /**
     * 商品编号
     * (必填)
     */
    @NotBlank
    private String goodsId;

    /**
     * 支付宝定义的统一商品编号
     * (特殊必填)
     */
    private String alipayGoodsId;

    /**
     * 商品名称
     * (选填)
     */
    private String goodsName;

    /**
     * 商品数量
     * (必填)
     */
    @NotNull
    private Integer quantity;

    /**
     * 商品单价，单位为元
     * (必填)
     */
    @NotBlank
    private String price;

    /**
     * 商品类目
     * (选填)
     */
    private String goodsCategory;

    /**
     * 商品描述信息
     * (选填)
     */
    private String productDes;

    /**
     * 商品的展示地址
     * (选填)
     */
    private String showUrl;
}