/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade.detail;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author wangqilei
 * @version OrderGoodsDetail.java, v 0.1 2024-06-05 3:43 PM wangqilei
 */
@Data
public class OrderGoodsDetail {
    /**
     * 商品的编号
     * 由半角的大小写字母、数字、中划线、下划线中的一 种或几种组成
     * (必填)
     */
    @NotBlank
    @JSONField(name = "goods_id")
    private String goodsId;

    /**
     * 商品的实际名称
     * (必填)
     */
    @NotBlank
    @JSONField(name = "goods_name")
    private String goodsName;

    /**
     * 微信支付定义的统一商品
     * 没有可不传
     * (选填)
     */
    @JSONField(name = "wxpay_goods_id")
    private String wxpayGoodsId;

    /**
     * 用户购买的商品数量
     * (必填)
     */
    @NotNull
    private Integer quantity;

    /**
     * 商品单价（单位分）
     * 如果商户有优惠，需传输商户优惠后 的 单价(例如：用户对一笔 100 元的订单使用了商场发的 优惠券 100-50，则活动商品的单价应为原单价-50)
     * (必填)
     */
    @NotNull
    private Integer price;
}