/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version PostarRefundQueryReq.java, v 0.1 2024-06-06 5:02 PM wangqilei
 */
@Data
public class PostarRefundQueryReq extends PostarBaseReq {
    /**
     * 服务商退款订单号
     * 服务商退款的时候上送的退款订单号。 对应星POS：tradeNo
     * (必填)
     */
    @NotBlank
    private String orderNo;

    /**
     * 商户号
     * 商户所在国通系统内商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 商户的手机号码
     * (特殊必填)
     */
    private String custLogin;

    /**
     * 订单场景类型
     * 00普通，01收银调终端，未传时默认00普通，使用收银调终端退款时必传01
     * (特殊必填)
     */
    private String orderType;

    /**
     * 设备类型
     * 对应星pos：trmTyp
     * (选填)
     */
    private String type;

    /**
     * 操作员号
     * 对应星pos：oprId
     * (选填)
     */
    private String operator;

    /**
     * 对应星pos：请求ip：reqip
     * (选填)
     */
    private String tradingIp;

    /**
     * 接入方式
     * 0:Android SDK 1:iOS SDK 2:windows SDK 3:直连（默认填3）。 对应星pos：opSys字段
     * (选填)
     */
    private String access;

    /**
     * 退款日期（暂未发布）
     * 格式yyyyMMdd，支持60天查询，不传默认查询当天。（邮支付是必传的）
     * (选填)
     */
    private String originTradeDate;

    // 以下是星POS项目可传专属值
    /**
     * 设备号
     * 星POS项目可传，其他项目无需，长度8位数字，进件生成终端号，对应星pos：trmNo
     * (选填)
     */
    private String driveNo;
    /**
     * 查询流水	星POS项目必填
     * (选填)
     */
    private String qryNo;
    /**
     * 查询流水时间	星POS项目必填
     * (选填)
     */
    private String qryDt;
    /**
     * 字符集
     * 默认传00-GBK
     * (选填)
     */
    private String characterSet;
    /**
     * 纬度
     * 星POS项目可传，其他项目无需
     * (选填)
     */
    private String latitude;
    /**
     * 经度
     * 星POS项目可传，其他项目无需
     * (选填)
     */
    private String longitude;

    /**
     * 接口请求时间. 格式yyyyMMddHHmmss
     */
    private String timeStamp;
}