/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.bankactivity.detail;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 银行补贴活动查询数据
 *
 * @author 吴安 * @version QueryActSubData.java, v 0.1 2024-11-25 10:54 吴安
 * @date 2024/11/25
 */
@Data
public class QueryActSubData implements Serializable {
    private static final long serialVersionUID = 4740386290839581866L;
    /**
     * 银行补贴活动编号
     */
    private String polId;
    /**
     * 银行补贴活动名称
     */
    private String polName;
    /**
     * 落地银行编号
     */
    private String fallAgetId;
    /**
     * 落地银行名称
     */
    private String ageName;
    /**
     * 活动开始时间
     */
    private String actStartTime;
    /**
     * 活动结束时间
     */
    private String actEndTime;
    /**
     * 活动规则
     */
    private String actRule;
    /**
     * 活动范围（地区码拼接，用分号隔开，如：310000;320000。0表示全国）
     */
    private String areaCodes;
    /**
     * 是否允许小微商户报名：1-是，0-否
     */
    private String isXwRegister;
    /**
     * 是否允许重复结算卡报名：1-是，0-否
     */
    private String isJskSign;
    /**
     * 补贴生效标识：0-提报生效， 1-入网实时生效
     */
    private String subsidyEffectPref;
    /**
     * 商户入网准入限制（指商户进件成功后，允许报名的月份，例如返回2，代表允许进件后的前两个月报名。）
     */
    private String cusAuthLimit;
    /**
     * 活动状态：1-生效中
     */
    private String actState;
    /**
     * 补充材料数组
     */
    private List<QueryActAddData> addList;
}