/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.trade.detail.OrderGoodsInfo;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * @author wangqilei
 * @version PostarPayReq.java, v 0.1 2024-06-05 3:07 PM wangqilei
 */
@Data
public class PostarScanCardCreateReq extends PostarBaseReq {
    private static final long serialVersionUID = -4699636659186370501L;

    /**
     * 商户号
     * 商户所在国通系统内的商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 服务商订单号（第三方订单号）
     * 该订单号需要唯一，最大长度40，只能由数字，大小写字母构成
     * (必填)
     */
    @NotBlank
    private String orderNo;

    /**
     * 订单金额
     * 单位分，国通系统内记录至流水（原订单交易金额）
     * (必填)
     */
    @NotBlank
    private String txamt;

    /**
     * 扫码支付授权码
     * 设备读取用户微信或支付宝中的条码或二维码信息（付款码）
     * (必填)
     */
    private String code;

    /**
     * 交易ip
     * 商户端终端设备 IP 地址，需传公网ip，若是动态ip，请提供经纬度（邮储数字货币交易必填）
     * (必填)
     */
    private String tradingIp;

    /**
     * 设备类型
     * P-智能POS A- app扫码 C-PC端 T-台牌扫码
     * (必填)
     */
    @NotBlank
    private String type;

    /**
     * 商户的手机号
     * (特殊必填)
     */
    private String custLogin;

    /**
     * 自定义设备编号，字母或数字，长度不超过32位
     * 字母或数字
     * (特殊必填)
     */
    private String driveNo;

    /**
     * 是否为“碰一下”交易
     * 1-是，其他为否
     * (特殊必填)
     */
    private String isPop;

    /**
     * 订单的说明或备注
     * (特殊必填)
     */
    private String remark;

    /**
     * 音箱编号
     * 使用国通音箱时，指定音箱播报的编号
     * (特殊必填)
     */
    private String spNo;

    /**
     * 订单标题，限制15字节
     * (特殊必填)
     */
    private String title;

    /**
     * 消费者设备支付定位的纬度
     * (特殊必填)
     */
    private String latitude;

    /**
     * 消费者设备支付定位的经度
     * (特殊必填)
     */
    private String longitude;

    /**
     * 操作员号
     * 可传店员标识
     * (特殊必填)
     */
    private String operator;

    /**
     * POS服务化第三方订单号
     * 用于国通设备非接口交易时异步订单生成，或POS发起交易时传输
     * (特殊必填)
     */
    private String serverThreeOrderNo;

    /**
     * 服务商机构标识码
     * 用于银联交易上送服务商机构PID使用
     * (特殊必填)
     */
    private String fpid;

    /**
     * 订单失效时间
     * 未传输时默认15，最小1分钟，最大值15分钟，单位（分）。
     * 以订单生成时间起，如10:15:00发起下单，则10:31:00点击无法支付订单失效，
     * 微信交易默认45秒失效无需传输，若下单后未接收异步，可在45秒后调用查询接口查询订单状态
     * (必填)
     */
    private String outTime;

    /**
     * 音箱开关
     * 0 关闭 1开启 （空值开启，明确为0关闭）
     * (选填)
     */
    private String speakerSwitch;

    /**
     * 异步通知地址
     * 未传时默认根据单项目配置异步地址进行通知，传输时根据请求异步地址进行通知，
     * 注：1.地址需提前报备国通进行转化，解析失败按照项目配置地址通知；2.退款无异步无需传输；3.数币交易暂不支持自定义异步地址
     * (特殊必填)
     */
    private String asyncNotify;

    /**
     * 实时费率
     * 单位%，支持小数点后两位，特殊项目需平台配置相关权限时生效，用于计算该笔交易实际手续费费率值
     * (特殊必填)
     */
    private BigDecimal realTimeRate;

    /**
     * 加密随机因子
     * 仅在被扫支付类交易报文中出现：若付款码为 19 位数字，则取后 6 位；
     * 若付款码为 EMV 二维码，则取其 tag 57 的卡号/token 号的后 6 位
     * (选填)
     */
    private String encryptRandNum;

    /**
     * 密文数据
     * 仅在被扫支付类交易报文中出现：64bit 的密文数据，对终端硬件序列号和加密 随机因子加密后的结果。
     * 本子域取值为：64bit 密文数据进行 base64 编码后的结果。
     * (选填)
     */
    private String secretText;

    /**
     * 终端应用程序版本号
     * (特殊必填)
     */
    private String apVersionNo;

    /**
     * 定位信息
     * 获取不到经纬度时，可传基站信息，基站信息格式：460|01|28958|26482475|
     * 注：邮储数字货币交易，经维度信息信息与基站信息必送其一
     * (特殊必填)
     */
    private String ugpsAddress;

    /**
     * 银行卡受理终端产品入网
     * 该编号由“中国银联标识产品企业资质认 证办公室”为通过入网认证的终端进行 分配。 格式：6 位字符，例如 P31000
     * (特殊必填)
     */
    private String networkLicense;

    /**
     * 当面付刷脸支付场景标识
     * (选填)
     */
    private String dynamicTokenOutBizNo;

    /**
     * 花呗分期
     * 花呗分期期数, 当前仅支持3、6、12
     * (选填)
     */
    private String hbFqNum;

    /**
     * 原订单金额
     * 星POS中转项目必传
     * (特殊必填)
     */
    private Integer txamtOrder;

    /**
     * 微信单品优惠活动
     * (非必填)
     */
    private OrderGoodsInfo detail;

    /**
     * 接口请求时间. 格式yyyyMMddHHmmss
     */
    private String timeStamp;
}