/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarUpdateCustRateReq.java, v 0.1 2024-10-09 16:59 weikunpeng
 */
@Data
public class PostarUpdateCustRateReq extends PostarBaseReq {

    /**
     * 商户号
     * 必传字段
     */
    @NotBlank(message = "商户号不能为空")
    private String custId;

    /**
     * 微信借记卡费率
     * 单位%，支持小数点后三位
     */
    private String rateWx;

    /**
     * 微信贷记卡费率
     * 单位% ，支持小数点后三位
     */
    private String rateWxD;

    /**
     * 支付宝费率
     * 单位% ，支持小数点后三位
     */
    private String rateZfb;

    /**
     * 银联扫码借记卡扣率小于1000费率
     * 单位% ，支持小数点后三位
     */
    private String rateYlCap0;

    /**
     * 银联扫码借记卡扣率大于1000费率
     * 单位% ，支持小数点后三位
     */
    private String rateYlCap1;

    /**
     * 银联扫码贷记卡扣率小于1000费率
     * 单位% ，支持小数点后三位
     */
    private String rateYlRat0;

    /**
     * 银联扫码贷记卡扣率大于1000费率
     * 单位% ，支持小数点后三位
     */
    private String rateYlRat1;

    /**
     * 提现手续费 D1附加手续费
     * 单位% ，支持小数点后两位
     */
    private String rateTx;

    /**
     * 借记卡优惠类结算费率
     * 单位% ，支持小数点后三位
     */
    private String ratePosJy;

    /**
     * 借记卡标准类结算费率
     * 单位% ，支持小数点后三位
     */
    private String ratePosJb;

    /**
     * 贷记卡优惠类结算费率
     * 单位% ，支持小数点后三位
     */
    private String ratePosDy;

    /**
     * 贷记卡标准类结算费率
     * 单位% ，支持小数点后三位
     */
    private String ratePosDb;

    /**
     * 免签免密结算费率
     * 单位% ，支持小数点后三位
     */
    private String ratePosM;

    /**
     * 刷卡闪付结算费率
     * 单位% ，支持小数点后三位
     */
    private String ratePosS;

    /**
     * 借记卡标准类消费封顶值
     * 单位分
     */
    private String moneyPosJb;

    /**
     * 借记卡优惠类消费封顶值
     * 单位分
     */
    private String moneyPosJy;

    /**
     * 银联扫码借记卡(≤1000)封顶值
     * 单位分，根据机构政策区间修改，未上送代表不修改原值
     */
    private String ylJFdDef;

    /**
     * 银联扫码借记卡(>1000)封顶值
     * 单位分，根据机构政策区间修改，未上送代表不修改原值
     */
    private String ylJFd2Def;

    /**
     * 时间戳
     * 必传字段
     */
    @NotBlank
    private String timeStamp;
}