/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarCommonOpenApplicationReq.java, v 0.1 2024-10-09 09:28 weikunpeng
 */
@Data
public class PostarCommonOpenApplicationReq extends PostarBaseReq {
    /**
     * 进件机构号。
     * 若“机构号”字段为虚拟机构号，则“进件机构号”字段必传。
     */
    private String applyAgetId;

    /**
     * 操作类型。
     * 1: 新增，2: 修改。
     * 必传
     */
    @NotBlank
    private String operType;

    /**
     * 是否首次进件（用于校验安心签，安心签必传）。
     * 0: 是，1: 驳回重新进件。
     * 可选
     */
    private String isFirstCust;

    /**
     * 登入账号（手机号）。
     * 必传
     */
    @NotBlank
    private String custLogin;

    /**
     * 商户号（修改时必须上传）。
     * 可选（仅在修改时必传）
     */
    private String custId;

    /**
     * 商户名称。
     * 不可为空，不超过50个字段（100个字符），需与营业执照、登记许可证、事业单位法人证书名一致。
     * 必传
     */
    @NotBlank
    private String busName;

    /**
     * 商户简称。
     * 建议输入市+名称+主营，长度控制在50个字以内（100个字符以内），
     * 建议长度5-20个字（10-40个字符）。
     */
    @NotBlank
    private String refName;

    /**
     * 营业执照号。
     * 必传
     */
    @NotBlank
    private String licenseno;

    /**
     * 营业执照有效期开始日期。
     * 格式为 YYYYMMDD。
     * 必传
     */
    @NotBlank
    private String busStartDate;

    /**
     * 营业执照有效期结束日期。
     * 格式为 YYYYMMDD，永久传"长期"。
     * 必传
     */
    @NotBlank
    private String busEndDate;

    /**
     * 主体类型。
     * 1: 个体工商户，2: 企业，3: 政府及事业单位，5: 其他机构组织。
     * 必传
     */
    @NotBlank
    private String busType;

    /**
     * 行业类型ID（需获取主体类型一致的 MCC）。
     * 需根据二级MCC目录对应行业编号。
     * 必传
     */
    @NotBlank
    private String mcccode;

    /**
     * 证书类型。
     * 当主体是事业单位或其他机构时必传。
     * 可选值包括：
     * 1. 事业单位法人证书
     * 2. 统一社会信用代码证书
     * 3. 有偿服务许可证（军队医院适用）
     * 4. 医疗机构执业许可证（军队医院适用）
     * 5. 企业营业执照（挂靠企业的党组织适用）
     * 6. 机构组织代码证（政府机关适用）
     * 7. 其他证书/批文/证明
     * 8. 社会团体法人登记证书
     * 9. 民办非企业单位登记证书
     * 10. 基金会法人登记证书
     * 11. 慈善组织公开募捐资格证书
     * 12. 农民专业合作社法人营业执照
     * 13. 宗教活动场所登记证书
     * 14. 基层群众性自治组织特别法人统一信用代码证
     * 15. 执业许可证/执业证（含律师事务所职业许可证、基层法律服务所执业证、司法鉴定许可证）
     * 16. 农村集体经济组织登记证
     * 必传（当主体是事业单位和其他时）
     */
    private String cretType;

    /**
     * 省。
     * 必传，基础信息获取板块-“获取省”接口。
     */
    @NotBlank
    private String provId;

    /**
     * 市。
     * 必传，基础信息获取板块-“获取市”接口。
     */
    @NotBlank
    private String cityId;

    /**
     * 区/县。
     * 必传，基础信息获取板块-“获取区县”接口。
     */
    @NotBlank
    private String areaId;

    /**
     * 商户经营地址。
     * 长度控制在100个字（200个字符），建议长度5-30个字（10-60个字符），
     * 系统将根据银联规范对地址进行长度补充与截取，少于5个字添加省市区进行补足，
     * 超过30个字的向后取值30个字。
     * 必传。
     */
    @NotBlank
    private String custAddr;

    /**
     * 经营者姓名。
     * 必传。
     */
    @NotBlank
    private String custName;

    /**
     * 法人证件类型 0:身份证，
     * 1:护照，
     * 2:港澳居民往来内地通行证（回乡证），
     * 3:台湾居民往来内地通行证（台胞证），
     * 4:外国人永久居留证，
     * 5港澳居民居住证，
     * 6:台湾居民居住证，
     * 7:执行事务合伙人。不填默认为0
     */
    @NotBlank
    private String nolegalCertType;


    /**
     * 法人证件号。
     * 必传。
     */
    @NotBlank
    private String credNo;

    /**
     * 法人身份证有效期开始日期。
     * 必传，格式为 YYYYMMDD。
     */
    @NotBlank
    private String credStartDate;

    /**
     * 法人身份证有效期结束日期。
     * 必传，格式为 YYYYMMDD，永久传"长期"。
     */
    @NotBlank
    private String credEndDate;

    /**
     * 手机号码。
     * 必传，经营者联系方式，可与“登入账号”一致。
     * 如果有安心签，需与安心签的开户手机号一致。
     */
    @NotBlank
    private String mobileNo;

    /**
     * 账户结算类型。
     * 必传，01 对公，02 法人对私，03 非法人对私。
     * 示例: "02"
     */
    @NotBlank
    private String accountType;

    /**
     * 结算户名。
     * 必传，默认结算姓名。
     */
    @NotBlank
    private String accountName;

    /**
     * 结算账号。
     * 必传。
     */
    @NotBlank
    private String accountNo;

    /**
     * 开户行（银行缩写）。
     * 必传，调用基础信息板块-银行信息查询/根据银行卡号获取银行信息获取。
     */
    @NotBlank
    private String bankCode;

    /**
     * 支行名称。
     * 必传，调用基础信息板块-查询联行号信息接口获取。
     */
    @NotBlank
    private String branchname;

    /**
     * 开户银行联行号。
     * 必传，调用基础信息板块-查询联行号信息接口获取。
     */
    @NotBlank
    private String bankno;

    /**
     * 非法人结算人姓名。
     * 非法人对私时填写。
     */
    private String stlName;

    /**
     * 非法人结算人证件类型
     * 非法人对私时填写。
     * 0:身份证，
     * 1:护照，
     * 2:港澳居民往来内地通行证（回乡证），
     * 3:台湾居民往来内地通行证（台胞证），
     * 4:外国人永久居留证，
     * 5港澳居民居住证，
     * 6:台湾居民居住证，
     * 7:执行事务合伙人。不填默认为0
     */
    private String accCredType;

    /**
     * 非法人结算人证件号
     * 必传: 否
     */
    private String accCredNo;

    /**
     * 非法人结算人证件有效期开始
     * 格式: YYYYMMDD
     * 必传: 否
     */
    private String accCredStartDate;

    /**
     * 非法人结算人证件有效期结束
     * 格式: YYYYMMDD，或"长期"
     * 必传: 否
     */
    private String accCredEndDate;

    /**
     * 微信借记卡费率
     * 单位: %, 支持小数点后三位
     * 必传: 是
     */
    @NotBlank
    private String rateWx;

    /**
     * 结算类型
     * 1: T1, 2: D1
     * 必传: 是
     */
    @NotBlank
    private String stlType;

    /**
     * 提现手续费D1附加手续费
     * 单位: %, 小数点后两位
     * 必传: 否
     */
    private String rateTx;

    /**
     * 微信贷记卡费率
     * 单位: %, 支持小数点后三位
     * 必传: 否
     */
    private String rateWxDj;

    /**
     * 支付宝扣率%
     * 单位: %, 支持小数点后三位
     * 必传: 是
     */
    @NotBlank
    private String rateZfb;

    /**
     * 银联扫码借记卡扣率小于1000费率
     * 单位: %, 支持小数点后三位
     * 必传: 是
     */
    @NotBlank
    private String rateYlCap0;

    /**
     * 银联扫码借记卡扣率大于1000费率
     * 单位: %, 支持小数点后三位
     * 必传: 是
     */
    @NotBlank
    private String rateYlCap1;

    /**
     * 银联扫码贷记卡扣率小于1000费率
     * 单位: %, 支持小数点后三位
     * 必传: 是
     */
    @NotBlank
    private String rateYlRat0;

    /**
     * 银联扫码贷记卡扣率大于1000费率
     * 单位: %, 支持小数点后三位
     * 必传: 是
     */
    @NotBlank
    private String rateYlRat1;

    /**
     * 借记卡优惠类结算费率
     * 单位: %, 支持小数点后三位
     * 必传: 是
     */
    @NotBlank
    private String ratePosJy;

    /**
     * 借记卡标准类结算费率
     * 单位: %, 支持小数点后三位
     * 必传: 是
     */
    @NotBlank
    private String ratePosJb;

    /**
     * 贷记卡优惠类结算费率
     * 单位: %, 支持小数点后三位
     * 必传: 是
     */
    @NotBlank
    private String ratePosDy;

    /**
     * 贷记卡标准类结算费率
     * 单位: %, 支持小数点后三位
     * 必传: 是
     */
    @NotBlank
    private String ratePosDb;

    /**
     * 借记卡优惠类消费封顶值
     * 单位: 分
     * 必传: 是
     */
    @NotBlank
    private String moneyPosJy;

    /**
     * 借记卡标准类消费封顶值
     * 单位: 分
     * 必传: 是
     */
    @NotBlank
    private String moneyPosJb;

    /**
     * 免签免密结算费率
     * 单位: %, 支持小数点后三位
     * 必传: 是
     * 说明: 早期给免签免密优惠类用的，目前无业务在用。
     */
    @NotBlank
    private String ratePosM;

    /**
     * 刷卡闪付结算费率
     * 单位: %, 支持小数点后三位
     * 必传: 是
     * 说明: 用手机PAY闪付的费率，闪付的金额小等于1000是按闪付费率，金额大于1000是按普通刷卡借贷记费率。
     */
    @NotBlank
    private String ratePosS;

    /**
     * 银联扫码借记卡(≤1000)封顶值
     * 单位: 分
     * 说明: 根据机构政策区间上送，未上送时会取政策的默认封顶值。若政策未配置封顶值，则无需上送（代表不封顶）。
     */
    private String ylJFdDef;

    /**
     * 银联扫码借记卡(>1000)封顶值
     * 单位: 分
     * 说明: 根据机构政策区间上送，未上送时会取政策的默认封顶值。若政策未配置封顶值，则无需上送（代表不封顶）。
     */
    private String ylJFd2Def;

    /**
     * 关联落地银行机构号
     * 说明: 当610机构类型为“行业代理/联合收单”时，可调用进件-基础信息获取-关联落地银行品牌查询、落地银行下级机构查询接口，获取落地银行。会校验结算卡是否属于落地银行。
     */
    private String fallAgetId;

    /**
     * 报备产品类型
     * 单位: 0全产品 1扫码 2刷卡
     * 必传: 是
     */
    @NotBlank
    private String custChanType;

    /**
     * 是否支持退款
     * 单位: '0'关；'1'开
     * 必传: 是
     */
    @NotBlank
    private String refPower;

    /**
     * 商户经营地址所在经度
     * 单位: 经度
     * 小数点后仅支持上传后5位，进行截取
     * 必传: 是
     */
    @NotBlank
    private String longitude;

    /**
     * 商户经营地址所在纬度
     * 单位: 纬度
     * 小数点后仅支持上传后5位，进行截取
     * 必传: 是
     */
    @NotBlank
    private String latitude;

    /**
     * 验证码（需要签署安心签才需传）
     * 说明: 安心签开通板块-“安心签发短信验证码”，验证码有效期10-30分钟（根据接收短信上提示时间为准）
     * 必传: 否
     */
    private String checkCode;

    /**
     * 图片接口时间戳
     * 说明: 首次进件必传，若商户首次进件被驳回后无需修改图片则无需传输。
     * 一个商户一个时间戳，使用首张图片国通服务器返回时间戳
     * 必传: 否
     */
    private String timestamp;
}