package com.fshows.postar.enums;

/**
 * 审核类型查询枚举
 * <p>
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
public enum AuitTypeEnum {
    NORMAL("0", "正常入网"),
    INFO_MODIFICATION("2", "信息修改"),
    ACCOUNT_CARD_MODIFICATION("4", "结算卡修改");

    private final String code;
    private final String description;

    AuitTypeEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static AuitTypeEnum getByCode(String code) {
        for (AuitTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return code + ": " + description;
    }
}
