package com.fshows.postar.apienum;

import com.fshows.postar.contant.PostarConstant;
import com.fshows.postar.request.trade.*;
import com.fshows.postar.response.trade.*;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;

/**
 * 国通星驿交易相关API
 *
 * @author liluqing
 * @version PostarTradeApiEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum PostarTradeApiEnum implements IApiDefinition {
    SCAN_CARD_CREATE(
            "商户主扫（B扫C）",
            "/yyfsevr/order/scanByMerchant",
            PostarConstant.DEFAULT_API_VERSION,
            PostarScanCardCreateReq.class,
            PostarScanCardCreateRes.class
    ),
    JS_API_PAY(
            "统一下单接口（C扫B）",
            "/yyfsevr/order/pay",
            PostarConstant.DEFAULT_API_VERSION,
            PostarJsApiPayCreateReq.class,
            PostarJsApiPayCreateRes.class
    ),
    ORDER_QUERY(
            "订单查询接口",
            "/yyfsevr/order/orderQuery",
            PostarConstant.DEFAULT_API_VERSION,
            PostarOrderQueryReq.class,
            PostarOrderQueryRes.class
    ),
    CLOSE_PAY(
            "扫码交易撤单/关单",
            "/yyfsevr/order/closePay",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCloseOrderReq.class,
            PostarCloseOrderRes.class
    ),
    REFUND_CREATE(
            "退款申请发起",
            "/yyfsevr/order/refund",
            PostarConstant.DEFAULT_API_VERSION,
            PostarRefundCreateReq.class,
            PostarRefundCreateRes.class
    ),
    REFUND_QUERY(
            "退款查询接口",
            "/yyfsevr/order/refundQuery",
            PostarConstant.DEFAULT_API_VERSION,
            PostarRefundQueryReq.class,
            PostarRefundQueryRes.class
    ),
    UNIOU_USER_ID_QUERY(
            "获取银联userId",
            "/yyfsevr/order/getPaypalTag",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUnionUserIdReq.class,
            PostarUnionUserIdRes.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本，默认1.0
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    PostarTradeApiEnum(String name,
                       String apiSubURI,
                       String version,
                       Class requestClass,
                       Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}