/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarAnxinSignSendCodeReq.java, v 0.1 2024-10-09 15:46 weikunpeng
 */
@Data
public class PostarAnxinSignSendCodeReq extends PostarBaseReq {

    /**
     * 商户号
     * 有商户号的情况下商户号必传，如补签时
     */
    private String custId;

    /**
     * 登录号（手机号）
     */
    @NotBlank
    private String custLogin;

    /**
     * 证件号
     */
    @NotBlank
    private String identNo;

    /**
     * 开户手机号
     * 需与开户的phone一致
     */
    @NotBlank
    private String phone;

    /**
     * 是否发送语音
     * 0:不发语音 1：发送语音，默认不发送
     */
    @NotBlank
    private String isSendVoice;

    /**
     * 时间戳
     * 格式yyyyMMddHHmmss
     */
    @NotBlank
    private String timeStamp;
}