/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.riskcore.common.tools;

import cn.hutool.crypto.SecureUtil;
import com.fshows.fsframework.core.utils.FsDateUtil;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.core.utils.Md5Util;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    public static final String ALL_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final Integer SALT_LENGHT = 18;
    public static final Integer BLOC_ACCOUNT_SALT_LENGTH = 8;

    public static String getDefaultIfBlank(Object obj, String defaultStr) {
        if (StringUtils.isEmpty((CharSequence)defaultStr)) {
            defaultStr = "";
        }
        if (obj == null) {
            return defaultStr;
        }
        String tmp = obj.toString();
        return (String)StringUtils.defaultIfBlank((CharSequence)tmp, (CharSequence)defaultStr);
    }

    public static String getRandomString(int length) {
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            sb.append(ALL_CHAR.charAt(number));
        }
        return sb.toString();
    }

    public static String betyToStringWithUTF8(byte[] bytes) {
        try {
            String body = new String(bytes, "UTF-8");
            return body;
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.error((Logger)log, (String)"\u5b57\u7b26\u4e32\u8f6c\u5316\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    public static Date timestampToDate(Long timestamp) {
        if (timestamp == null || timestamp == 0L) {
            return null;
        }
        return new Date(timestamp);
    }

    public static <T> void setDefaultStringValue(T t, String defaultString) {
        try {
            for (Field f : t.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                if (String.class != f.getType()) continue;
                if (null == f.get(t)) {
                    f.set(t, defaultString);
                    continue;
                }
                f.set(t, StringUtils.trimToEmpty((String)f.get(t).toString()));
            }
        }
        catch (IllegalAccessException e) {
            LogUtil.error((Logger)log, (String)"\u8bbe\u7f6e\u5bf9\u8c61\u53c2\u6570\u9ed8\u8ba4\u503c\u5f02\u5e38, Ex={}", (Object[])new Object[]{ExceptionUtils.getStackTrace((Throwable)e)});
        }
    }

    public static <T> void setDefaultNullValue(T t, T newT) {
        try {
            Field[] fs;
            for (Field f : fs = t.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Object v1 = f.get(newT);
                Object v2 = f.get(t);
                if (null != v1 || v2 == null) continue;
                f.set(newT, v2);
            }
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"\u8bbe\u7f6e\u5bf9\u8c61\u53c2\u6570\u9ed8\u8ba4\u503c\u5f02\u5e38, Ex={}", (Object[])new Object[]{ExceptionUtils.getStackTrace((Throwable)e)});
        }
    }

    public static int getZeroTime(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, days);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date zero = calendar.getTime();
        return (int)(zero.getTime() / 1000L);
    }

    public static Date getTodayTime(int hours, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, hours);
        calendar.set(12, minute);
        calendar.set(13, second);
        return calendar.getTime();
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static void main(String[] args) {
        System.out.println(CommonUtils.dealStoreIds(Arrays.asList(1111, 2222), 11));
        System.out.println(CommonUtils.createOnlyId("BLOC"));
    }

    public static String mobileEncrypt(String mobile) {
        if (StringUtils.isEmpty((CharSequence)mobile) || mobile.length() != 11) {
            return mobile;
        }
        return mobile.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public static String dealStoreIds(List<Integer> storeIds) {
        return CommonUtils.dealStoreIds(storeIds, 300);
    }

    public static String dealStoreIds(List<Integer> storeIds, int length) {
        if (storeIds == null || storeIds.isEmpty()) {
            return "";
        }
        String storeIdStr = StringUtils.join((Object[])storeIds.toArray(), (String)",");
        if (storeIdStr.length() > length) {
            try {
                String tempStoreIdStr = storeIdStr.substring(0, length);
                int lastCommaIndex = tempStoreIdStr.lastIndexOf(",");
                if (lastCommaIndex != -1) {
                    return tempStoreIdStr.substring(0, lastCommaIndex);
                }
            }
            catch (Exception e) {
                LogUtil.error((Logger)log, (String)"\u5458\u5de5\u5904\u7406\u95e8\u5e97\u5931\u8d25\uff01", (Throwable)e);
            }
            return "";
        }
        return storeIdStr;
    }

    public static boolean storeIdsLengthOverLimit(List<Integer> storeIds, int length) {
        if (storeIds == null || storeIds.isEmpty()) {
            return false;
        }
        String storeIdStr = StringUtils.join((Object[])storeIds.toArray(), (String)",");
        return storeIdStr.length() > length;
    }

    public static String generateApplyId(Integer uid, String merchantNo) {
        StringBuilder stringBuilder = new StringBuilder(uid.toString());
        if (StringUtils.isNotBlank((CharSequence)merchantNo)) {
            stringBuilder.append(merchantNo);
        }
        stringBuilder.append(FsDateUtil.getCurrentSecond().toString());
        return SecureUtil.md5((String)stringBuilder.toString());
    }

    public static String generateLogId() {
        return Md5Util.sign((String)UUID.randomUUID().toString());
    }

    public static String createOnlyId(String business) {
        String randomNumeric = RandomStringUtils.randomNumeric((int)6);
        String timeStr = FsDateUtil.getReqDateyyyyMMddHHmmss((Date)new Date());
        return String.format("%s%s%s", business, timeStr, randomNumeric);
    }
}

