/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.riskcore.common.enums;

import cn.hutool.core.collection.CollectionUtil;
import com.beust.jcommander.internal.Lists;
import com.fshows.lifecircle.riskcore.common.enums.DataTypeCodeEnum;
import com.fshows.lifecircle.riskcore.common.enums.RiskWorkOrderStatusEnum;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum SinanFastSearchTypeEnum {
    WXTS("WXTS", "\u5fae\u4fe1\u6295\u8bc9", Arrays.asList(DataTypeCodeEnum.WX_TS.getName(), DataTypeCodeEnum.LS_WX_TS.getName(), DataTypeCodeEnum.SXF_WX_TS.getName()), "\u5fae\u4fe1\u6295\u8bc9"),
    WXWG("WXWG", "\u5fae\u4fe1\u8fdd\u89c4", Arrays.asList(DataTypeCodeEnum.LS_WX_WG.getName(), DataTypeCodeEnum.SXF_WX_WG.getName(), DataTypeCodeEnum.WX_WG.getName()), "\u5fae\u4fe1\u8fdd\u89c4"),
    WXLJ("WXLJ", "\u5fae\u4fe1\u62e6\u622a", Arrays.asList(DataTypeCodeEnum.WX_LJ.getName()), "\u5fae\u4fe1\u62e6\u622a"),
    RISKGO("RISKGO", "\u652f\u4ed8\u5b9d\u98ce\u9669\u5de5\u5355", Arrays.asList(DataTypeCodeEnum.ZFB.getName(), DataTypeCodeEnum.LS_ZFB_WG.getName(), DataTypeCodeEnum.SXF_ZFB.getName()), "\u652f\u4ed8\u5b9d\u98ce\u9669\u5de5\u5355"),
    RISKGJ("RISKGJ", "\u652f\u4ed8\u5b9d\u544a\u8b66", Arrays.asList(DataTypeCodeEnum.LS_ZFB_GJ.getName()), "\u652f\u4ed8\u5b9d\u544a\u8b66"),
    CHANNEL("CHANNEL", "\u901a\u9053\u65b9", Arrays.asList(DataTypeCodeEnum.LS.getName(), DataTypeCodeEnum.FB.getName(), DataTypeCodeEnum.SXF.getName()), "\u901a\u9053\u65b9"),
    YSFRISKGO("YSFRISKGO", "\u4e91\u95ea\u4ed8\u98ce\u9669\u5de5\u5355", Arrays.asList(DataTypeCodeEnum.LS_YSF.getName()), "\u4e91\u95ea\u4ed8\u98ce\u9669\u5de5\u5355"),
    REJECTAPPEAL("REJECTAPPEAL", "\u7533\u8bc9\u9a73\u56de", Arrays.asList(RiskWorkOrderStatusEnum.FIRST_EXAMINE_NO_PASS.getValue().toString(), RiskWorkOrderStatusEnum.REVIEW_NO_PASS.getValue().toString()), "\u7533\u8bc9\u9a73\u56de"),
    TRADECLOSE("TRADECLOSE", "\u4ea4\u6613\u5173\u95ed", null, null),
    TRADEOPEN("TRADEOPEN", "\u4ea4\u6613\u5f00\u542f", null, null),
    SETTLECLOSE("SETTLECLOSE", "\u7ed3\u7b97\u5173\u95ed", null, null),
    SETTLEOPEN("SETTLEOPEN", "\u7ed3\u7b97\u5f00\u542f", null, null);

    private String value;
    private String name;
    private List<String> dataTypeCodes;
    private String dataTypesName;

    private SinanFastSearchTypeEnum(String value, String name, List<String> dataTypeCodes, String dataTypesName) {
        this.value = value;
        this.name = name;
        this.dataTypeCodes = dataTypeCodes;
        this.dataTypesName = dataTypesName;
    }

    public static SinanFastSearchTypeEnum getByValue(String value) {
        SinanFastSearchTypeEnum[] valueList;
        for (SinanFastSearchTypeEnum v : valueList = SinanFastSearchTypeEnum.values()) {
            if (!v.getValue().equals(value)) continue;
            return v;
        }
        return null;
    }

    public boolean matches(String value) {
        return StringUtils.isBlank((CharSequence)value) ? false : this.value.equals(value);
    }

    public static boolean isMatchesTradeOrSettle(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return TRADECLOSE.matches(value) || TRADEOPEN.matches(value) || SETTLECLOSE.matches(value) || SETTLEOPEN.matches(value);
    }

    public static SinanFastSearchTypeEnum getByDataTypeCode(String dataTypeCode) {
        SinanFastSearchTypeEnum[] valueList;
        if (StringUtils.isBlank((CharSequence)dataTypeCode)) {
            return null;
        }
        for (SinanFastSearchTypeEnum v : valueList = SinanFastSearchTypeEnum.values()) {
            if (!CollectionUtil.isNotEmpty(v.getDataTypeCodes()) || !v.getDataTypeCodes().contains(dataTypeCode)) continue;
            return v;
        }
        return null;
    }

    public static boolean isRejectAppeal(List<Integer> orderStatusList) {
        if (CollectionUtil.isEmpty(orderStatusList)) {
            return false;
        }
        List<String> rejectAppealOrderStatusList = REJECTAPPEAL.getDataTypeCodes();
        if (CollectionUtil.isEmpty(rejectAppealOrderStatusList)) {
            return false;
        }
        List targetList = Lists.newArrayList();
        rejectAppealOrderStatusList.forEach(object -> targetList.add(Integer.valueOf(object)));
        return orderStatusList.containsAll(targetList) && targetList.containsAll(orderStatusList);
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getDataTypeCodes() {
        return this.dataTypeCodes;
    }

    public String getDataTypesName() {
        return this.dataTypesName;
    }
}

