/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.datacore.facade.domain.response.alipaymerchant;

import cn.hutool.core.collection.CollectionUtil;
import com.fshows.lifecircle.datacore.facade.domain.request.alipaymerchant.TimeLineRequest;
import com.fshows.lifecircle.datacore.facade.domain.response.alipaymerchant.ChannelStatisticResponse;
import com.fshows.lifecircle.datacore.facade.domain.response.alipaymerchant.TradeAnalysisResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class MerchantTradeAnalysisQueryResponse
implements Serializable {
    private static final long serialVersionUID = -4443329283573103039L;
    private List<TradeAnalysisResponse> tradeAnalysisList;

    public static MerchantTradeAnalysisQueryResponse init(List<TimeLineRequest> timelineList) {
        if (CollectionUtil.isEmpty(timelineList)) {
            return new MerchantTradeAnalysisQueryResponse();
        }
        MerchantTradeAnalysisQueryResponse response = new MerchantTradeAnalysisQueryResponse();
        ArrayList<TradeAnalysisResponse> tradeAnalysisList = new ArrayList<TradeAnalysisResponse>(timelineList.size());
        for (TimeLineRequest timeLine : timelineList) {
            TradeAnalysisResponse tradeAnalysisResponse = MerchantTradeAnalysisQueryResponse.getTradeAnalysisResponse(timeLine);
            tradeAnalysisList.add(tradeAnalysisResponse);
        }
        response.setTradeAnalysisList(tradeAnalysisList);
        return response;
    }

    private static TradeAnalysisResponse getTradeAnalysisResponse(TimeLineRequest timeLine) {
        TradeAnalysisResponse tradeAnalysisResponse = new TradeAnalysisResponse();
        tradeAnalysisResponse.setStartTime(timeLine.getStartTime());
        tradeAnalysisResponse.setEndTime(timeLine.getEndTime());
        tradeAnalysisResponse.setTotalCount(0);
        tradeAnalysisResponse.setTotalAmount(BigDecimal.ZERO);
        tradeAnalysisResponse.setSettleAmount(BigDecimal.ZERO);
        tradeAnalysisResponse.setRefundAmount(BigDecimal.ZERO);
        tradeAnalysisResponse.setChannelStatisticList(new ArrayList<ChannelStatisticResponse>());
        return tradeAnalysisResponse;
    }

    public List<TradeAnalysisResponse> getTradeAnalysisList() {
        return this.tradeAnalysisList;
    }

    public void setTradeAnalysisList(List<TradeAnalysisResponse> tradeAnalysisList) {
        this.tradeAnalysisList = tradeAnalysisList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MerchantTradeAnalysisQueryResponse)) {
            return false;
        }
        MerchantTradeAnalysisQueryResponse other = (MerchantTradeAnalysisQueryResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<TradeAnalysisResponse> this$tradeAnalysisList = this.getTradeAnalysisList();
        List<TradeAnalysisResponse> other$tradeAnalysisList = other.getTradeAnalysisList();
        return !(this$tradeAnalysisList == null ? other$tradeAnalysisList != null : !((Object)this$tradeAnalysisList).equals(other$tradeAnalysisList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MerchantTradeAnalysisQueryResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TradeAnalysisResponse> $tradeAnalysisList = this.getTradeAnalysisList();
        result = result * 59 + ($tradeAnalysisList == null ? 43 : ((Object)$tradeAnalysisList).hashCode());
        return result;
    }

    public String toString() {
        return "MerchantTradeAnalysisQueryResponse(tradeAnalysisList=" + this.getTradeAnalysisList() + ")";
    }

    public MerchantTradeAnalysisQueryResponse(List<TradeAnalysisResponse> tradeAnalysisList) {
        this.tradeAnalysisList = tradeAnalysisList;
    }

    public MerchantTradeAnalysisQueryResponse() {
    }
}

