/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.datacore.facade.enums;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public enum TradeSumTipEnum {
    DIRECT("DIRECT", "\u5fae\u4fe1/\u652f\u4ed8\u5b9d\u76f4\u8fde", "\u6ce8\uff1a\u5fae\u4fe1/\u652f\u4ed8\u5b9d\u7b7e\u7ea6\u7684\u76f4\u8fde\u5546\u6237\uff0c\u5f53\u65e5\u5230\u8d26\u91d1\u989d\u548c\u624b\u7eed\u8d39\u4ee5\u6b21\u65e512\u70b9\u540e\u4e3a\u51c6\u3002"),
    ALIPAY_SUBSIDY("ALIPAY_SUBSIDY", "\u53c2\u4e0e\u652f\u4ed8\u5b9d\u8865\u8d34\u91d1", "\u6ce8\uff1a\u53c2\u4e0e\u652f\u4ed8\u5b9d\u8865\u8d34\u91d1\u7684\u5546\u6237\uff0c\u5f53\u65e5\u5230\u8d26\u91d1\u989d\u3001\u624b\u7eed\u8d39\u548c\u8865\u8d34\u91d1\u4ee5\u6b21\u65e512\u70b9\u540e\u4e3a\u51c6\u3002"),
    HB_INTEREST_SUBSIDY("HB_INTEREST_SUBSIDY", "\u53c2\u4e0e\u82b1\u5457\u5206\u671f\u8d34\u606f", "\u6ce8\uff1a\u53c2\u4e0e\u82b1\u5457\u5206\u671f\u8d34\u606f\u7684\u5546\u6237\uff0c\u5f53\u65e5\u5230\u8d26\u91d1\u989d\u3001\u624b\u7eed\u8d39\u548c\u8d34\u606f\u91d1\u989d\u4ee5\u6b21\u65e512\u70b9\u540e\u4e3a\u51c6\u3002"),
    ALIPAY_PREPAY_CARD("ALIPAY_PREPAY_CARD", "\u5f00\u901a\u652f\u4ed8\u5b9d\u9884\u4ed8\u5361", "\u6ce8\uff1a\u5f00\u901a\u652f\u4ed8\u5b9d\u9884\u4ed8\u5361\u7684\u5546\u6237\uff0c\u5f53\u65e5\u5230\u8d26\u91d1\u989d\u548c\u624b\u7eed\u8d39\u4ee5\u6b21\u65e512\u70b9\u540e\u4e3a\u51c6\u3002"),
    XFT_DIRECT("XFT_DIRECT", "\u661f\u5bcc\u901a\u7b7e\u7ea6\u7684\u5546\u6237", "\u6ce8\uff1a\u5f53\u65e5\u5230\u8d26\u91d1\u989d\u548c\u624b\u7eed\u8d39\u9700\u4ee5\u6b21\u65e515\u70b9\u540e\u4e3a\u51c6\u3002");

    private static final String TIP_FORMAT1 = "\u5f00\u901a\u670d\u52a1/\u6d3b\u52a8\u7684\u5546\u6237 ? \uff0c\u5f53\u65e5\u5230\u8d26\u91d1\u989d\u548c\u624b\u7eed\u8d39\u4ee5\u6b21\u65e5{}\u70b9\u540e\u4e3a\u51c6";
    private static final String TIP_FORMAT2 = "\u5f00\u901a\u670d\u52a1/\u6d3b\u52a8\u7684\u5546\u6237 ? \uff0c\u5f53\u65e5\u5230\u8d26\u91d1\u989d\u3001\u624b\u7eed\u8d39\u548c\u8865\u8d34\u91d1\u4ee5\u6b21\u65e5{}\u70b9\u540e\u4e3a\u51c6";
    private static final String TIP_FORMAT3 = "\u5f00\u901a\u670d\u52a1/\u6d3b\u52a8\u7684\u5546\u6237 ? \uff0c\u5f53\u65e5\u5230\u8d26\u91d1\u989d\u3001\u624b\u7eed\u8d39\u548c\u8d34\u606f\u91d1\u989d\u4ee5\u6b21\u65e5{}\u70b9\u540e\u4e3a\u51c6";
    private static final String TIP_FORMAT4 = "\u5f00\u901a\u670d\u52a1/\u6d3b\u52a8\u7684\u5546\u6237 ? \uff0c\u5f53\u65e5\u5230\u8d26\u91d1\u989d\u3001\u624b\u7eed\u8d39\u3001\u8d34\u606f\u91d1\u989d\u548c\u8865\u8d34\u91d1\u4ee5\u6b21\u65e5{}\u70b9\u540e\u4e3a\u51c6";
    private static final String TIP_XFT_EFFECT_TIME = "15";
    private static final String TIP_DEFAULT_EFFECT_TIME = "12";
    private final String code;
    private final String desc;
    private final String singleTip;

    private TradeSumTipEnum(String code, String desc, String singleTip) {
        this.code = code;
        this.desc = desc;
        this.singleTip = singleTip;
    }

    public static TradeSumTipsModel getTradeSumTip(boolean directMerchant, boolean subsidyMerchant, boolean hbInterestSubsidy, boolean alipayPrepayCard, boolean xftDirect) {
        TradeSumTipsModel tradeSumTipsModel = new TradeSumTipsModel();
        ArrayList tradeSumTipEnums = Lists.newArrayList();
        if (directMerchant) {
            tradeSumTipEnums.add(DIRECT);
        }
        if (subsidyMerchant) {
            tradeSumTipEnums.add(ALIPAY_SUBSIDY);
        }
        if (hbInterestSubsidy) {
            tradeSumTipEnums.add(HB_INTEREST_SUBSIDY);
        }
        if (alipayPrepayCard) {
            tradeSumTipEnums.add(ALIPAY_PREPAY_CARD);
        }
        if (xftDirect) {
            tradeSumTipEnums.add(XFT_DIRECT);
        }
        String tip = "";
        int tipFlag = 0;
        StringBuilder specialTip = new StringBuilder();
        if (tradeSumTipEnums.size() == 1) {
            tip = ((TradeSumTipEnum)((Object)tradeSumTipEnums.get(0))).getSingleTip();
        } else if (tradeSumTipEnums.size() > 1) {
            tipFlag = 1;
            specialTip.append("\n");
            String effectTime = TIP_DEFAULT_EFFECT_TIME;
            if (tradeSumTipEnums.contains((Object)XFT_DIRECT)) {
                effectTime = TIP_XFT_EFFECT_TIME;
            }
            tip = StrUtil.format((CharSequence)TIP_FORMAT1, (Object[])new Object[]{effectTime});
            if (tradeSumTipEnums.contains((Object)ALIPAY_SUBSIDY) && !tradeSumTipEnums.contains((Object)HB_INTEREST_SUBSIDY)) {
                tip = StrUtil.format((CharSequence)TIP_FORMAT2, (Object[])new Object[]{effectTime});
            }
            if (tradeSumTipEnums.contains((Object)HB_INTEREST_SUBSIDY) && !tradeSumTipEnums.contains((Object)ALIPAY_SUBSIDY)) {
                tip = StrUtil.format((CharSequence)TIP_FORMAT3, (Object[])new Object[]{effectTime});
            }
            if (tradeSumTipEnums.contains((Object)ALIPAY_SUBSIDY) && tradeSumTipEnums.contains((Object)HB_INTEREST_SUBSIDY)) {
                tip = StrUtil.format((CharSequence)TIP_FORMAT4, (Object[])new Object[]{effectTime});
            }
            for (int i = 1; i <= tradeSumTipEnums.size(); ++i) {
                TradeSumTipEnum tradeSumTipEnum = (TradeSumTipEnum)((Object)tradeSumTipEnums.get(i - 1));
                specialTip.append(i).append(".").append(tradeSumTipEnum.getDesc());
                if (i >= tradeSumTipEnums.size()) continue;
                specialTip.append("\n");
            }
        }
        tradeSumTipsModel.setTip(tip);
        tradeSumTipsModel.setTipFlag(tipFlag);
        tradeSumTipsModel.setSpecialTip(specialTip.toString());
        return tradeSumTipsModel;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getSingleTip() {
        return this.singleTip;
    }

    public static class TradeSumTipsModel {
        private String tip;
        private Integer tipFlag;
        private String specialTip;

        public String getTip() {
            return this.tip;
        }

        public Integer getTipFlag() {
            return this.tipFlag;
        }

        public String getSpecialTip() {
            return this.specialTip;
        }

        public void setTip(String tip) {
            this.tip = tip;
        }

        public void setTipFlag(Integer tipFlag) {
            this.tipFlag = tipFlag;
        }

        public void setSpecialTip(String specialTip) {
            this.specialTip = specialTip;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TradeSumTipsModel)) {
                return false;
            }
            TradeSumTipsModel other = (TradeSumTipsModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tip = this.getTip();
            String other$tip = other.getTip();
            if (this$tip == null ? other$tip != null : !this$tip.equals(other$tip)) {
                return false;
            }
            Integer this$tipFlag = this.getTipFlag();
            Integer other$tipFlag = other.getTipFlag();
            if (this$tipFlag == null ? other$tipFlag != null : !((Object)this$tipFlag).equals(other$tipFlag)) {
                return false;
            }
            String this$specialTip = this.getSpecialTip();
            String other$specialTip = other.getSpecialTip();
            return !(this$specialTip == null ? other$specialTip != null : !this$specialTip.equals(other$specialTip));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TradeSumTipsModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tip = this.getTip();
            result = result * 59 + ($tip == null ? 43 : $tip.hashCode());
            Integer $tipFlag = this.getTipFlag();
            result = result * 59 + ($tipFlag == null ? 43 : ((Object)$tipFlag).hashCode());
            String $specialTip = this.getSpecialTip();
            result = result * 59 + ($specialTip == null ? 43 : $specialTip.hashCode());
            return result;
        }

        public String toString() {
            return "TradeSumTipEnum.TradeSumTipsModel(tip=" + this.getTip() + ", tipFlag=" + this.getTipFlag() + ", specialTip=" + this.getSpecialTip() + ")";
        }
    }
}

