/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.accountcore.facade.enums;

import org.apache.commons.lang3.StringUtils;

public enum LiquidationCompanyEnum {
    LS("\u4e50\u5237", "LS", null),
    HF("\u6c47\u4ed8", "HF", null),
    SD("\u886b\u5fb7", "SD", null),
    OLD_SXF("\u8001\u968f\u884c\u4ed8", "SXF", null),
    DIRECT_SXF("\u76f4\u8fde\u968f\u884c\u4ed8", "DIRECT_SXF", "SXPAY"),
    DIRECT_LS("\u76f4\u8fde\u4e50\u5237", "DIRECT_LS", "LESHUA");

    private String name;
    private String value;
    private String payCompanyCode;

    private LiquidationCompanyEnum(String name, String value, String payCompanyCode) {
        this.name = name;
        this.value = value;
        this.payCompanyCode = payCompanyCode;
    }

    public static LiquidationCompanyEnum getByValue(String value) {
        LiquidationCompanyEnum[] valueList;
        for (LiquidationCompanyEnum v : valueList = LiquidationCompanyEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getValue(), (CharSequence)value)) continue;
            return v;
        }
        return null;
    }

    public static LiquidationCompanyEnum getByPayCompanyCode(String payCompanyCode) {
        LiquidationCompanyEnum[] valueList;
        for (LiquidationCompanyEnum v : valueList = LiquidationCompanyEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getPayCompanyCode(), (CharSequence)payCompanyCode)) continue;
            return v;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getPayCompanyCode() {
        return this.payCompanyCode;
    }
}

