package com.fshows.leshuapay.sdk.response.activity;

import lombok.Data;

import java.io.Serializable;

/**
 * LsActivityInfoResponse
 *
 * @author Think
 * @version 1.0
 * @since 2025/11/18
 */
@Data
public class LeshuaActivityInfoResponse implements Serializable {
    private static final long serialVersionUID = 6577540499295061885L;
    /**
     * 活动编码
     */
    private String code;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 绑卡状态 0=无效，10=未预约，20=已预约，30=已开卡，40=已绑卡，50=已指派
     */
    private Integer cardBindStatus;

    /**
     * 活动状态1：未上架；2：进行中；3：已下架；4：已过期
     */
    private Integer activityStatus;

    /**
     * 卡BIN长度
     */
    private Integer cardBinLength;

    /**
     * 卡BIN号列表，逗号分隔
     */
    private String cardBins;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 商户ID
     */
    private String merchantId;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 结算账户名称
     */
    private String settleName;

    /**
     * 开卡服务 0=需要上门开卡， 10=不需上门开卡 30=需要网点开卡
     */
    private Integer optType;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 账户绑定时间
     */
    private String accountBindTime;

    /**
     * 新银行卡ID
     */
    private Object cardBankNewId;

    /**
     * 客户经理ID
     */
    private Object managerId;

    /**
     * 银行备注
     */
    private String bankRemark;

    /**
     * 营销员ID
     */
    private Integer marketerId;

    /**
     * 备注信息
     */
    private String remark;

    /**
     * 活动参与状态  0-正常 1-已退出
     */
    private Integer joinState;

    /**
     * 补贴类型 0=商户 10=代理商
     */
    private Integer settleType;

    /**
     * 灵工协议签约地址
     */
    private Object agreementUrl;

    /**
     * 签约状态 0-未签 1-已签 -1-不涉及
     */
    private Integer signStatus;
}