/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.share;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.QueryCanSubAmountNewResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wangyi
 * @version QueryCanSubAmountNewRequest.java, v 0.1 2022-05-19 15:22
 */
@EqualsAndHashCode(callSuper = true)
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class QueryCanSubAmountNewRequest extends LeshuaBizRequest<QueryCanSubAmountNewResponse> {

    /**
     * level
     * 当前只支持 realtime（实时查询）
     */
    private String level;

    /**
     * 商户号
     */
    private String accountNo;

    @Override
    public Class<QueryCanSubAmountNewResponse> getResponseClass() {
        return QueryCanSubAmountNewResponse.class;
    }
}
