/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.settlement;

import com.fshows.leshuapay.sdk.enums.BookTypeEnum;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantWithdrawBalanceQueryNewResponse;
import com.fshows.leshuapay.sdk.response.settlement.MerchantWithdrawBalanceQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author youmingming
 * @version MerchantWithdrawBalanceQueryNewRequest.java, v 0.1 2021-04-01 1:57 下午 youmingming
 */
@Data
public class MerchantWithdrawBalanceQueryNewRequest extends LeshuaBizRequest<MerchantWithdrawBalanceQueryNewResponse> {

    private static final long serialVersionUID = 2203919892048459383L;
    /**
     * 乐刷商编
     */
    @NotBlank(message = "乐刷商编不能为空")
    private String merchantId;

    /**
     * 账本类型
     * @see BookTypeEnum
     * 商户待结算账本：2031
     * 商户待分账账本：2025
     * 不填默认查待结算账本
     */
    private String bookTypeNo;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantWithdrawBalanceQueryNewResponse> getResponseClass() {
        return MerchantWithdrawBalanceQueryNewResponse.class;
    }
}