/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 商户基本信息
 *
 * @author zhaoyi
 * @version BaseInfo.java, v 0.1 2020-07-27 11:55 zhaoyi
 */
@Data
public class BaseInfo implements Serializable {
    private static final long serialVersionUID = -483169670344268051L;

    /**
     * 1: 个人
     * 2: 个体
     * 3: 企业
     */
    @NotNull(message = "商户类型不能为空")
    private Integer merchantType;

    /**
     * 商户简称
     * 不能为纯数字（可允许全英文）
     * 不能包含：藏独,法轮功,色情,毒品,赌博,博彩,基金,理财,担保,贷款,集资,P2P,麻醉,间谍服务,私人侦探,股权,众筹,
     * 乐刷,套现,千万户,000,t0,信用卡,官方,担保,资金,淘宝,财务,收款,超时,商圈
     */
    @NotBlank(message = "商户简称不能为空")
    @Length(min = 2, max = 20, message = "商户简称超长")
    private String merchantShortName;

    /**
     * 商户名称，(与营业执照全称一致，有营业执照的填营业执照上的名称)，小微商户填“商户_XXX”（XXX为身份证姓名）
     */
    @NotBlank(message = "商户名称不能为空")
    @Length(min = 2, max = 40, message = "商户名称超长")
    private String merchantName;

    /**
     * 客服电话
     */
    @Length(max = 20, message = "客服电话超长")
    private String servicePhone;

    /**
     * MCC码商户行业编号
     */
    @NotBlank(message = "商户行业编号不能为空")
    @Length(max = 4, message = "商户行业编号超长")
    private String mccCode;
}
