/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.share;

import lombok.Data;

import java.io.Serializable;

/**
 * 分账退款查询
 *
 * @author linzy
 * @version RefundQueryResponse.java, v 0.1 2021-05-06 11:50 linzy
 */
@Data
public class LeshuaShareRefundQueryResponse implements Serializable {

    private static final long serialVersionUID = 9081885643421090693L;

    /**
     * 乐刷商户号
     */
    private String merchantId;

    /**
     * 第三方订单号
     */
    private String thirdOrderId;

    /**
     * 乐刷订单号
     */
    private String leshuaOrderId;

    /**
     * 乐刷退款单号
     */
    private String leshuaRefundId;

    /**
     * 第三方退款单号
     */
    private String thirdRefundId;

    /**
     * 订单金额
     */
    private String orderAmount;

    /**
     * 订单余额
     */
    private String orderBalance;

    /**
     * 退款成功时间，退款成功才会返回
     */
    private String refundTime;

    /**
     * 支付状态
     */
    private String status;

    /**
     * 错误信息
     */
    private String retcode;

    /**
     * 错误信息
     */
    private String retmsg;

    /**
     * 退款金额
     */
    private String refundAmount;
}
