/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 花呗分期数枚举
 *
 * @author zhaoyi
 * @version HbFqNumEnum.java, v 0.1 2020-08-03 15:05 zhaoyi
 */
public enum HbFqNumEnum {
    THREE(3, "3期"),
    SIX(6, "6期"),
    TWELVE(12, "12期"),
    ;

    private Integer type;
    private String desc;

    HbFqNumEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static HbFqNumEnum getByType(Integer type) {
        HbFqNumEnum[] valueList = HbFqNumEnum.values();
        for (HbFqNumEnum v : valueList) {
            if (v.getType().equals(type)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>type</tt>.
     *
     * @return property value of type
     */
    public Integer getType() {
        return type;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
