/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.pay;

import lombok.Data;

/**
 * 乐刷退款request
 * @author xiaotian
 * @version LeshuaRefundRequest.java, v 0.1 2020-07-29 8:57
 */
@Data
public class LeshuaRefundResponse extends LeshuaBasePayResponse {

    /**
     * 附加数据
     * 退款成功原样返回；注意：只能是汉字、英文字母、数字
     */
    private String attach;

    /**
     * 商户号 由乐刷分配
     */
    private String merchantId;

    /**
     * 微信、支付宝、QRC商户号
     */
    private String subMerchantId;

    /**
     * 随机字符串
     */
    private String nonceStr;

    /**
     * 退款订单状态
     */
    private String status;

    /**
     * 乐刷订单号
     */
    private String leshuaOrderId;

    /**
     * 退款金额
     */
    private String refundAmount;

    /**
     * 商户退款订单号
     */
    private String merchantRefundId;

    /**
     * 商户订单号
     */
    private String thirdOrderId;

    /**
     * 乐刷退款订单号
     */
    private String leshuaRefundId;

    /**
     * 订单总金额
     */
    private String totalAmount;

    /**
     * 订单余额：本次退款后订单剩余金额
     */
    private String orderBalance;

    /**
     * 实际退款金额
     */
    private String settlementRefundAmount;

    /**
     * 折扣退款金额
     */
    private String discountRefundAmount;

    /**
     * 退款优惠详情
     */
    private String refundDetail;
}

