/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 商户类型枚举
 *
 * @author zhaoyi
 * @version MerchantTypeEnum.java, v 0.1 2020-08-03 10:56 zhaoyi
 */
public enum MerchantTypeEnum {
    PERSONAL(1, "个人"),
    INDIVIDUAL(2, "个体"),
    ENTERPRISE(3, "企业"),
    ;

    private Integer type;
    private String desc;

    MerchantTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static MerchantTypeEnum getByType(Integer type) {
        MerchantTypeEnum[] valueList = MerchantTypeEnum.values();
        for (MerchantTypeEnum v : valueList) {
            if (v.getType().equals(type)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>type</tt>.
     *
     * @return property value of type
     */
    public Integer getType() {
        return type;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
