/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.response.trade.detail;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author wangqilei
 * @version PayInfo.java, v 0.1 2024-07-03 4:53 PM wangqilei
 */
@Data
public class PayInfo {
    /**
     * 支付宝交易过程中返回的唯一标识
     * (选填)
     */
    private String tradeNo;

    /**
     * 支付宝或微信交易请求的状态码，通常为0表示成功
     * (特殊必填)
     */
    private Integer status;

    /**
     * 微信支付请求中的时间戳，非必填，仅在微信支付时返回
     * (特殊必填)
     */
    private String timeStamp;

    /**
     * 微信支付请求中的应用ID，非必填，仅在微信支付时返回
     * (特殊必填)
     */
    private String appId;

    /**
     * 微信支付请求中的随机字符串，非必填，仅在微信支付时返回
     * (特殊必填)
     */
    private String nonceStr;

    /**
     * 微信支付请求中的包，包含prepay_id等参数，非必填，仅在微信支付时返回
     * (特殊必填)
     */
    @JSONField(name = "package")
    private String wechatPackage;

    /**
     * 微信支付请求中的加密类型，非必填，仅在微信支付时返回
     * (特殊必填)
     */
    private String signType;

    /**
     * 微信支付请求中的签名，非必填，仅在微信支付时返回
     * (特殊必填)
     */
    private String paySign;

    /**
     * 银联支付请求中的跳转URL，用于拉起银联APP收银台
     * (选填)
     */
    private String redirectUrl;
}