/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.kqbill.response;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import lombok.Data;

/**
 * @author liluqing
 * @version NestBizRequest.java, v 0.1 2023-12-12 16:23
 */
@Data
public class KqbillBizRes implements IResponseDefinition {
    /**
     * 报文的header内容
     */
    private KqbillHeaderRes head;

    /**
     * 系统交易层应答码，表示交易业务状态处理情况，参见错误码表
     * (必填)
     */
    private String bizResponseCode;

    /**
     * 对应系统交易层应答码的错误提示信息
     * (必填)
     */
    private String bizResponseMessage;

    @Data
    public static class KqbillHeaderRes {
        /**
         * 应答码
         */
        private String responseCode;

        /**
         * 应答码文本消息
         */
        private String responseTextMessage;

        /**
         * 接口版本号，标识当前消息，默认值为1.0.0
         * (必填)
         */
        private String version;

        /**
         * 区分报文功能，每种报文类型不同，例如A7009代表统一后台下单
         * (必填)
         */
        private String messageType;

        /**
         * 快钱公司分配给商户的11位账户号
         * (必填)
         */
        private String vendorMemberCode;

        /**
         * 快钱公司分配给商户的11位账户号
         * (必填)
         */
        private String memberCode;

        /**
         * 商户提供的该笔预下单交易的商户订单号，商户需保证每笔交易订单号唯一
         * (必填)
         */
        private String externalRefNumber;
    }
}

