/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package
        com.fshows.kqbill.request.trade.detail;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 *
 * @author liluqing
 * @version KqbillJsApiPayDataMapReq.java, v 0.1 2025-01-06 下午1:35
 */
@Data
public class KqbillJsApiPayDataMapReq {

    /**
     * 微信--goodsTag
     * 注：请求交易支持微信订单优
     * 惠标记时，微信优惠券可用，微
     * 信商户自定义的门订单优惠标记，在微信服务商后台配置优惠
     * 券时进行自定义，具体传值请于
     * 支付服务商沟通确认
     */
    private String goodsTag;

    /**
     * 支付宝优惠信息标识{"promo_params":{"promo_tag":"test_abc"}}
     */
    @JSONField(name = "promo_params")
    private PromoParamsReq promoParams;

    /**
     * 1-附加字段透传；
     */
    private String transmitFlag;

    /**
     * 银二参数
     */
    private String acqAddnData;

    /**
     * 微信参数
     */
    @JSONField(name = "scene_info")
    private String sceneInfo;

    /**
     * 支付宝--扩展参数
     */
    @JSONField(name = "extend_params")
    private String extendParams;

    /**
     * 支付宝--业务参数
     */
    @JSONField(name = "business_params")
    private String businessParams;


    /**
     * 扫码预授权标识（扫码预授权交
     * 易时，请必须传）
     */
    private String preAuthFlag;

    /**
     * 二级子商户号信息（无感支付平台类商户必送）
     */
    private String cupAppSubMerId;

    /**
     *
     * 二级商户名称（无感支付平台类商户必送）
     */
    private String cupAppSubMerName;

    /**
     * 二级商户简称（无感支付平台类商户必送）
     */
    private String cupAppSubMerAbbr;


}