/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.request.trade;

import com.fshows.kqbill.request.KqbillBizReq;
import com.fshows.kqbill.request.trade.detail.GoodDetail;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author wangqilei
 * @version KqbillOrderReverseReq.java, v 0.1 2024-07-03 5:11 PM wangqilei
 */
@Data
public class KqbillOrderReverseReq extends KqbillBizReq {
    /**
     * 商户在快钱的唯一标识
     */
    @NotBlank
    @Length(max = 15, message = "merchantId长度不能超过15")
    private String merchantId;

    /**
     * 快钱分配给商户的终端编号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "terminalId长度不能超过15")
    private String terminalId;

    /**
     * 原订单控制编号，原支付交易返回的订单控制编号，超时撤销可以不传，其他情况必须传
     */
    @Length(max = 20, message = "origOrderCtrl长度不能超过20")
    private String origOrderCtrl;

    /**
     * 原支付商户订单号
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "origRefNumber长度不能超过32")
    private String origRefNumber;

    /**
     * 异步通知地址，上送则覆盖系统默认配置的地址（如需开通请告知快钱运维人员）
     */
    @Length(max = 128, message = "tr3Url长度不能超过128")
    private String tr3Url;

    /**
     * 商品信息列表
     */
    private List<GoodDetail> isvGoodsList;
}