package com.fshows.kqbill.apienum;

import com.fshows.kqbill.contant.KqbillConstant;
import com.fshows.kqbill.request.trade.*;
import com.fshows.kqbill.response.trade.*;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;

/**
 * 快钱交易相关API
 *
 * @author liluqing
 * @version KqbillTradeApiEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum KqbillTradeApiEnum implements IApiDefinition {
    JS_API_PAY(
            "统一下单接口（C扫B）",
            "A7009",
            KqbillConstant.DEFAULT_API_VERSION,
            KqbillJsApiPayCreateReq.class,
            KqbillJsApiPayCreateRes.class
    ),
    ORDER_STATUS_QUERY(
            "订单状态查询接口",
            "A7002",
            KqbillConstant.DEFAULT_API_VERSION,
            KqbillOrderStatusQueryReq.class,
            KqbillOrderStatusQueryRes.class
    ),
    ORDER_INFO_QUERY(
            "订单退款详情查询接口",
            "A7006",
            KqbillConstant.DEFAULT_API_VERSION,
            KqbillOrderInfoQueryReq.class,
            KqbillOrderInfoQueryRes.class
    ),
    ORDER_REVERSE(
            "当天交易退款",
            "A7004",
            KqbillConstant.DEFAULT_API_VERSION,
            KqbillOrderReverseReq.class,
            KqbillOrderReverseRes.class
    ),
    ORDER_REFUND(
            "非当天交易退款",
            "A7003",
            KqbillConstant.DEFAULT_API_VERSION,
            KqbillRefundCreateReq.class,
            KqbillRefundCreateRes.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 交易码
     */
    private String transCode;
    /**
     * 接口版本，默认1.0
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    KqbillTradeApiEnum(String name,
                       String transCode,
                       String version,
                       Class requestClass,
                       Class responseClass) {
        this.name = name;
        this.transCode = transCode;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return transCode;
    }


    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}