/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.trade;

import com.fshows.steward.annotation.NoSign;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 商户结算接口
 *
 * @author
 * @version FuStdMchntDrawoutRes.java, v 0.1 2024-01-02 16:29:28
 */
@Data
public class FuStdMchntDrawoutRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555993082904L;


    /**
     * 商户流水号
     * 商户流水号
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 结算批次号
     * 结算批次号
     * (选填)
     */
    @NoSign
    private String batchNo;

    /**
     * 结算账户类型
     * 01 对私， 02 对公
     * (必填)
     */
    @NotBlank
    private String cleanType;

    /**
     * 结算金额
     * 结算金额
     * (必填)
     */
    @NotNull
    private Integer cleanAmt;

}