/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved
 */
package com.fshows.steward.response.account.item;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author liubo
 * @version QueryConcentrateRelationItem.java, v 0.1 2024-01-10-3:23 下午 liubo
 */
@Data
public class QueryConcentrateRelationItem {
    /**
     * 被归集商户号
     * 被归集商户号
     * (必填)
     */
    @NotBlank
    private String mchntCdConcentrate;

    /**
     * 授权申请号
     * 授权申请号
     * (选填)
     */
    private String batchNo;

    /**
     * 归集模式
     * 01:余额归集
     02:按转结金额归集
     03:订单预归集
     04:订单事后归集
     * (必填)
     */
    @NotBlank
    private List<String> concentrateTypes;

    /**
     * 订单归集最大比例
     * 订单归集最大比例
     * (选填)
     */
    private Integer orderConcentrateScale;

    /**
     * 余额归集最大比例
     * 余额归集最大比例
     * (选填)
     */
    private Integer balanceConcentrateScale;

    /**
     * 资金用途
     * 01:缴纳品牌费
     02:缴纳管理费
     03:缴纳服务费
     04:资金归集
     05:缴纳其他费用
     * (选填)
     */
    private String useType;

    /**
     * 授权状态
     * 00：初始化
     01：成功
     02：已拒绝
     03：关系解除
     N04：授权失败
     05：失效
     * (必填)
     */
    @NotBlank
    private String status;

    /**
     * 发起授权时间
     * YYYY-MM-DD HH:MM:SS
     * (选填)
     */
    private String createDate;

    /**
     * 生效时间
     * YYYY-MM-DD HH:MM:SS
     * (选填)
     */
    private String startDate;

    /**
     * 失效时间
     * YYYY-MM-DD HH:MM:SS
     * (选填)
     */
    private String endDate;
}