/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.steward.response.account.item;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 *
 * @author liluqing
 * @version FuStdQueryAccountInSettleItem.java, v 0.1 2024-03-21 15:49
 */
@Data
public class FuStdQueryAccountInSettleItem implements Serializable {

    private static final long serialVersionUID = -2213838555275657770L;


    /**
     * 富友批次号
     * (选填)
     */
    private String batchNo;

    /**
     * 富友交易参考号
     * (选填)
     */
    private String srcFasSsn;

    /**
     * 原交易商户流水号
     * (选填)
     */
    private String mchntCdTraceNo;

    /**
     * 源交易商户子流水号
     * (选填)
     */
    private String mchntCdChildTraceNo;

    /**
     * 结算方式
     *   01 自动结算，02 委托结算
     * (必填)
     */
    @NotBlank
    private String settleType;

    /**
     * 入账卡号
     * (必填)
     */
    @NotBlank
    private String outAcntNo;

    /**
     * 金额(分)
     * (必填)
     */
    @NotBlank
    private String amt;

    /**
     * 手续费(分)
     * (必填)
     */
    @NotBlank
    private String fee;

    /**
     * 代税服务费(分)
     *
     * (必填)
     */
    @NotBlank
    private String generationTaxFee;

    /**
     * 税费
     * (必填)
     */
    private String taxFee;

    /**
     * 到账金额
     * (必填)
     */
    private String arrivalAmt;

    /**
     * 发票形式
     * 01 委托代征，02 个体工商户
     * (必填)
     */
    @NotBlank
    private String invoiceType;

    /**
     * 分账/转账状态
     * 01 处理中
     * 05 成功
     * 06 失败
     * (必填)
     */
    private String status;

    /**
     * 结算状态
     * 01 结算成功
     * 02 结算失败
     * 08 结算中
     * 09 已结算,状态未知
     * 07 银行退票
     * (必填)
     */
    @NotBlank
    private String allocateStatus;

    /**
     * 失败原因描述
     * (必填)
     */
    @NotBlank
    private String cleanDesc;
}