/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import com.fshows.steward.annotation.NoSign;
import com.fshows.steward.request.FuStewardBizRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 用户绑/解卡接口
 *
 * @author
 * @version FuStdModifyCustomerBankCardReq.java, v 0.1 2023-12-28 15:15:00
 */
@Data
public class FuStdModifyCustomerBankCardReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555115427902L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 用户编号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "accountIn长度不能超过30")
    private String accountIn;

    /**
     * 业务类型
     * 1 绑卡， 2 解绑
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "type长度不能超过1")
    private String type;

    /**
     * 开户行行号
     * 另提供附件《开户行信息列表》，对公必填。
     * (选填)
     */
    @Length(max = 12, message = "interBankNo长度不能超过12")
    private String interBankNo;

    /**
     * 个体工商户用户必传
     * 枚举值：
     * 01 法人对私卡
     * 02 企业对公户
     */
    @NoSign
    private String outAcntNoType;

    /**
     *   户名
     * 类型为 01 法人对私卡时必传
     */
    @NoSign
    private String outAcntNm;

    /**
     * 身份证号
     * 类型为 01 法人对私卡时必传
     */
    @NoSign
    private String certNo;

    /**
     * 原 CJ001 接口创建的企业/个
     * 体户用户，绑卡时必传
     */
    @NoSign
    private String shxyNo;

    /**
     * 银行账号
     * 银行账号
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "outAcntNo长度不能超过40")
    private String outAcntNo;

    /**
     * 验证类型
     * 1 短信模式， 2 返回 url 不传默认 1
     * (选填)
     */
    @Length(max = 1, message = "checkType长度不能超过1")
    private String checkType;

    /**
     * 手机号码
     * 短信模式下，如手机号未传，短信下发至开户手机号
     * (选填)
     */
    @Length(max = 20, message = "mobile长度不能超过20")
    @NoSign
    private String mobile;
}