/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.trade.order;

import com.fshows.fuiou.enums.FuiouBankPayApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBankPayBizRequest;
import com.fshows.fuiou.response.trade.order.FuiouBankCardPayOrderQueryResponse;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouBankCardPayOrderQueryRequest.java, v 0.1 2023-10-12 19:54:02
 */
@Data
@ToString(callSuper = true)
public class FuiouBankCardPayOrderQueryRequest extends FuiouBankPayBizRequest<FuiouBankCardPayOrderQueryResponse, FuiouBankPayApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = 8014940907535369935L;
    /**
     * 交易清算日期，查隔天交易时必传日期格式（yyyyMMdd）
     *
     * (选填)
     */
    private String kbpsSrcSettleDt;

    /**
     * 富友商户号
     */
    private String mchntCd;
}